/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.json.JsonObject;
import java.util.List;

@VertxGen
public interface Context {
    public static boolean isOnWorkerThread() {
        Thread t = Thread.currentThread();
        return t instanceof VertxThread && ((VertxThread)((Object)t)).isWorker();
    }

    public static boolean isOnEventLoopThread() {
        Thread t = Thread.currentThread();
        return t instanceof VertxThread && !((VertxThread)((Object)t)).isWorker();
    }

    public static boolean isOnVertxThread() {
        return Thread.currentThread() instanceof VertxThread;
    }

    public void runOnContext(Handler<Void> var1);

    public <T> void executeBlocking(Handler<Promise<T>> var1, boolean var2, Handler<AsyncResult<@Nullable T>> var3);

    public <T> void executeBlocking(Handler<Promise<T>> var1, Handler<AsyncResult<@Nullable T>> var2);

    public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> var1, boolean var2);

    public <T> Future<T> executeBlocking(Handler<Promise<T>> var1);

    public String deploymentID();

    public @Nullable JsonObject config();

    public List<String> processArgs();

    public boolean isEventLoopContext();

    public boolean isWorkerContext();

    public <T> T get(String var1);

    public void put(String var1, Object var2);

    public boolean remove(String var1);

    public <T> T getLocal(String var1);

    public void putLocal(String var1, Object var2);

    public boolean removeLocal(String var1);

    public Vertx owner();

    public int getInstanceCount();

    @Fluent
    public Context exceptionHandler(@Nullable Handler<Throwable> var1);

    @GenIgnore
    public @Nullable Handler<Throwable> exceptionHandler();

    @GenIgnore(value={"permitted-type"})
    public void addCloseHook(Closeable var1);

    @GenIgnore(value={"permitted-type"})
    public boolean removeCloseHook(Closeable var1);
}

