/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.DeliveryContext;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.eventbus.impl.HandlerHolder;
import io.vertx.core.eventbus.impl.HandlerRegistration;
import io.vertx.core.eventbus.impl.MessageConsumerImpl;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.MessageProducerImpl;
import io.vertx.core.eventbus.impl.OutboundDeliveryContext;
import io.vertx.core.eventbus.impl.ReplyHandler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.impl.utils.ConcurrentCyclicSequence;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class EventBusImpl
implements EventBus,
MetricsProvider {
    static final Logger log = LoggerFactory.getLogger(EventBusImpl.class);
    private final List<Handler<DeliveryContext>> sendInterceptors = new CopyOnWriteArrayList<Handler<DeliveryContext>>();
    private final List<Handler<DeliveryContext>> receiveInterceptors = new CopyOnWriteArrayList<Handler<DeliveryContext>>();
    private final AtomicLong replySequence = new AtomicLong(0L);
    protected final VertxInternal vertx;
    protected final EventBusMetrics metrics;
    protected final ConcurrentMap<String, ConcurrentCyclicSequence<HandlerHolder>> handlerMap = new ConcurrentHashMap<String, ConcurrentCyclicSequence<HandlerHolder>>();
    protected final CodecManager codecManager = new CodecManager();
    protected volatile boolean started;
    private final ContextInternal sendNoContext;

    public EventBusImpl(VertxInternal vertx) {
        VertxMetrics metrics = vertx.metricsSPI();
        this.vertx = vertx;
        this.metrics = metrics != null ? metrics.createEventBusMetrics() : null;
        this.sendNoContext = vertx.getOrCreateContext();
    }

    @Override
    public <T> EventBus addOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.sendInterceptors.add(interceptor);
        return this;
    }

    @Override
    public <T> EventBus addInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.receiveInterceptors.add(interceptor);
        return this;
    }

    @Override
    public <T> EventBus removeOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.sendInterceptors.remove(interceptor);
        return this;
    }

    Iterator<Handler<DeliveryContext>> receiveInterceptors() {
        return this.receiveInterceptors.iterator();
    }

    @Override
    public <T> EventBus removeInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.receiveInterceptors.remove(interceptor);
        return this;
    }

    @Override
    public synchronized void start(Handler<AsyncResult<Void>> completionHandler) {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        completionHandler.handle(Future.succeededFuture());
    }

    @Override
    public EventBus send(String address, Object message) {
        return this.send(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus send(String address, Object message, DeliveryOptions options) {
        MessageImpl msg = this.createMessage(true, address, options.getHeaders(), message, options.getCodecName());
        this.sendOrPubInternal(msg, options, null, null);
        return this;
    }

    @Override
    public <T> Future<Message<T>> request(String address, Object message, DeliveryOptions options) {
        MessageImpl msg = this.createMessage(true, address, options.getHeaders(), message, options.getCodecName());
        ReplyHandler<T> handler = this.createReplyHandler(msg, true, options);
        this.sendOrPubInternal(msg, options, handler, null);
        return handler.result();
    }

    @Override
    public <T> MessageProducer<T> sender(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, true, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> sender(String address, DeliveryOptions options) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options, "options");
        return new MessageProducerImpl(this.vertx, address, true, options);
    }

    @Override
    public <T> MessageProducer<T> publisher(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, false, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options, "options");
        return new MessageProducerImpl(this.vertx, address, false, options);
    }

    @Override
    public EventBus publish(String address, Object message) {
        return this.publish(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus publish(String address, Object message, DeliveryOptions options) {
        this.sendOrPubInternal(this.createMessage(false, address, options.getHeaders(), message, options.getCodecName()), options, null, null);
        return this;
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new MessageConsumerImpl(this.vertx, this.vertx.getOrCreateContext(), this, address, false);
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer = this.consumer(address);
        consumer.handler((Handler)handler);
        return consumer;
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new MessageConsumerImpl(this.vertx, this.vertx.getOrCreateContext(), this, address, true);
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer = this.localConsumer(address);
        consumer.handler((Handler)handler);
        return consumer;
    }

    @Override
    public EventBus registerCodec(MessageCodec codec) {
        this.codecManager.registerCodec(codec);
        return this;
    }

    @Override
    public EventBus unregisterCodec(String name) {
        this.codecManager.unregisterCodec(name);
        return this;
    }

    @Override
    public <T> EventBus registerDefaultCodec(Class<T> clazz, MessageCodec<T, ?> codec) {
        this.codecManager.registerDefaultCodec(clazz, codec);
        return this;
    }

    @Override
    public EventBus unregisterDefaultCodec(Class clazz) {
        this.codecManager.unregisterDefaultCodec(clazz);
        return this;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.checkStarted();
        this.unregisterAll();
        if (this.metrics != null) {
            this.metrics.close();
        }
        if (completionHandler != null) {
            this.vertx.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public EventBusMetrics<?> getMetrics() {
        return this.metrics;
    }

    public MessageImpl createMessage(boolean send, String address, MultiMap headers, Object body, String codecName) {
        Objects.requireNonNull(address, "no null address accepted");
        MessageCodec codec = this.codecManager.lookupCodec(body, codecName);
        MessageImpl msg = new MessageImpl(address, headers, body, codec, send, this);
        return msg;
    }

    protected <T> HandlerHolder<T> addRegistration(String address, HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly, Handler<AsyncResult<Void>> completionHandler) {
        LocalRegistrationResult<T> result = this.addLocalRegistration(address, registration, replyHandler, localOnly);
        this.addRegistration(result.newAddress, result.holder, completionHandler);
        return result.holder;
    }

    protected <T> void addRegistration(boolean newAddress, HandlerHolder<T> holder, Handler<AsyncResult<Void>> completionHandler) {
        completionHandler.handle(Future.succeededFuture());
    }

    private <T> LocalRegistrationResult<T> addLocalRegistration(String address, HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly) {
        Objects.requireNonNull(address, "address");
        ContextInternal context = registration.context;
        HandlerHolder<T> holder = new HandlerHolder<T>(registration, address, replyHandler, localOnly, context);
        ConcurrentCyclicSequence<HandlerHolder<T>> handlers = new ConcurrentCyclicSequence<HandlerHolder<T>>().add(holder);
        ConcurrentCyclicSequence actualHandlers = this.handlerMap.merge(address, handlers, (old, prev) -> old.add(prev.first()));
        if (context.deploymentID() != null) {
            HandlerEntry<T> entry = new HandlerEntry<T>(address, registration);
            context.addCloseHook(entry);
        }
        boolean newAddress = handlers == actualHandlers;
        return new LocalRegistrationResult<T>(holder, newAddress);
    }

    protected <T> void removeRegistration(HandlerHolder<T> holder, Promise<Void> promise) {
        boolean last = this.removeLocalRegistration(holder);
        this.removeRegistration(last ? holder : null, holder.address, promise);
    }

    protected <T> void removeRegistration(HandlerHolder<T> handlerHolder, String address, Promise<Void> promise) {
        promise.complete();
    }

    private <T> boolean removeLocalRegistration(HandlerHolder<T> holder) {
        boolean last;
        boolean bl = last = this.handlerMap.compute(holder.address, (key, val) -> {
            if (val == null) {
                return null;
            }
            ConcurrentCyclicSequence<HandlerHolder> next = val.remove(holder);
            return next.size() == 0 ? null : next;
        }) == null;
        if (holder.setRemoved() && holder.getContext().deploymentID() != null) {
            holder.getContext().removeCloseHook(new HandlerEntry<T>(holder.address, holder.getHandler()));
        }
        return last;
    }

    protected <T> void sendReply(MessageImpl replyMessage, DeliveryOptions options, ReplyHandler<T> replyHandler) {
        if (replyMessage.address() == null) {
            throw new IllegalStateException("address not specified");
        }
        ContextInternal ctx = this.vertx.getOrCreateContext();
        if (ctx == null) {
            ctx = this.sendNoContext;
        }
        this.sendOrPubInternal(new OutboundDeliveryContext<T>(ctx, replyMessage, options, replyHandler, null));
    }

    protected <T> void sendOrPub(OutboundDeliveryContext<T> sendContext) {
        this.sendLocally(sendContext);
    }

    protected void callCompletionHandlerAsync(Handler<AsyncResult<Void>> completionHandler) {
        if (completionHandler != null) {
            this.vertx.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
        }
    }

    private <T> void sendLocally(OutboundDeliveryContext<T> sendContext) {
        ReplyException failure = this.deliverMessageLocally(sendContext.message);
        if (failure != null) {
            sendContext.written(failure);
        } else {
            sendContext.written(null);
        }
    }

    protected boolean isMessageLocal(MessageImpl msg) {
        return true;
    }

    protected ReplyException deliverMessageLocally(MessageImpl msg) {
        ConcurrentCyclicSequence handlers = (ConcurrentCyclicSequence)this.handlerMap.get(msg.address());
        if (handlers != null) {
            if (msg.isSend()) {
                HandlerHolder holder = (HandlerHolder)handlers.next();
                if (this.metrics != null) {
                    this.metrics.messageReceived(msg.address(), !msg.isSend(), this.isMessageLocal(msg), holder != null ? 1 : 0);
                }
                if (holder != null) {
                    this.deliverToHandler(msg, holder);
                }
            } else {
                if (this.metrics != null) {
                    this.metrics.messageReceived(msg.address(), !msg.isSend(), this.isMessageLocal(msg), handlers.size());
                }
                for (HandlerHolder holder : handlers) {
                    this.deliverToHandler(msg, holder);
                }
            }
            return null;
        }
        if (this.metrics != null) {
            this.metrics.messageReceived(msg.address(), !msg.isSend(), this.isMessageLocal(msg), 0);
        }
        return new ReplyException(ReplyFailure.NO_HANDLERS, "No handlers for address " + msg.address);
    }

    protected void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Event Bus is not started");
        }
    }

    protected String generateReplyAddress() {
        return "__vertx.reply." + Long.toString(this.replySequence.incrementAndGet());
    }

    <T> ReplyHandler<T> createReplyHandler(MessageImpl message, boolean src, DeliveryOptions options) {
        long timeout = options.getSendTimeout();
        String replyAddress = this.generateReplyAddress();
        message.setReplyAddress(replyAddress);
        ReplyHandler handler = new ReplyHandler(this, this.vertx.getOrCreateContext(), replyAddress, message.address, src, timeout);
        handler.register();
        return handler;
    }

    public <T> OutboundDeliveryContext<T> newSendContext(MessageImpl message, DeliveryOptions options, ReplyHandler<T> handler, Promise<Void> writePromise) {
        ContextInternal ctx = this.vertx.getContext();
        if (ctx == null) {
            ctx = this.sendNoContext;
        }
        return new OutboundDeliveryContext<T>(ctx, message, options, handler, writePromise);
    }

    public <T> void sendOrPubInternal(OutboundDeliveryContext<T> senderCtx) {
        this.checkStarted();
        senderCtx.iter = this.sendInterceptors.iterator();
        senderCtx.bus = this;
        senderCtx.metrics = this.metrics;
        senderCtx.next();
    }

    public <T> void sendOrPubInternal(MessageImpl message, DeliveryOptions options, ReplyHandler<T> handler, Promise<Void> writePromise) {
        this.checkStarted();
        this.sendOrPubInternal(this.newSendContext(message, options, handler, writePromise));
    }

    private void unregisterAll() {
        for (ConcurrentCyclicSequence handlers : this.handlerMap.values()) {
            for (HandlerHolder holder : handlers) {
                holder.getHandler().unregister(ar -> {});
            }
        }
    }

    private <T> void deliverToHandler(MessageImpl msg, HandlerHolder<T> holder) {
        MessageImpl copied = msg.copyBeforeReceive();
        holder.getContext().runOnContext(v -> {
            try {
                if (!holder.isRemoved()) {
                    holder.getHandler().receive(copied);
                }
            }
            finally {
                if (holder.isReplyHandler()) {
                    holder.getHandler().unregister(ar -> {});
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        this.close(ar -> {});
        super.finalize();
    }

    public class HandlerEntry<T>
    implements Closeable {
        final String address;
        final HandlerRegistration<T> handler;

        public HandlerEntry(String address, HandlerRegistration<T> handler) {
            this.address = address;
            this.handler = handler;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            HandlerEntry entry = (HandlerEntry)o;
            if (!this.address.equals(entry.address)) {
                return false;
            }
            return this.handler.equals(entry.handler);
        }

        public int hashCode() {
            int result = this.address != null ? this.address.hashCode() : 0;
            result = 31 * result + (this.handler != null ? this.handler.hashCode() : 0);
            return result;
        }

        @Override
        public void close(Promise<Void> completion) {
            this.handler.unregister(completion);
        }
    }

    private static class LocalRegistrationResult<T> {
        final HandlerHolder<T> holder;
        final boolean newAddress;

        LocalRegistrationResult(HandlerHolder<T> holder, boolean newAddress) {
            this.holder = holder;
            this.newAddress = newAddress;
        }
    }
}

