/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.clustered;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.HandlerHolder;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.OutboundDeliveryContext;
import io.vertx.core.eventbus.impl.clustered.ClusterNodeInfo;
import io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import io.vertx.core.eventbus.impl.clustered.ConnectionHolder;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.HAManager;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import io.vertx.core.spi.cluster.ClusterManager;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;

public class ClusteredEventBus
extends EventBusImpl {
    private static final Logger log = LoggerFactory.getLogger(ClusteredEventBus.class);
    public static final String CLUSTER_PUBLIC_HOST_PROP_NAME = "vertx.cluster.public.host";
    public static final String CLUSTER_PUBLIC_PORT_PROP_NAME = "vertx.cluster.public.port";
    private static final Buffer PONG = Buffer.buffer(new byte[]{1});
    private static final String SERVER_ID_HA_KEY = "server_id";
    private static final String SUBS_MAP_NAME = "__vertx.subs";
    private final ClusterManager clusterManager;
    private final ConcurrentMap<ServerID, ConnectionHolder> connections = new ConcurrentHashMap<ServerID, ConnectionHolder>();
    private EventBusOptions options;
    private AsyncMultiMap<String, ClusterNodeInfo> subs;
    private Set<String> ownSubs = new ConcurrentHashSet<String>();
    private ServerID serverID;
    private ClusterNodeInfo nodeInfo;
    private NetServer server;

    public ClusteredEventBus(VertxInternal vertx, VertxOptions options, ClusterManager clusterManager) {
        super(vertx);
        this.options = options.getEventBusOptions();
        this.clusterManager = clusterManager;
    }

    private NetServerOptions getServerOptions() {
        NetServerOptions serverOptions = new NetServerOptions(this.options.toJson());
        ClusteredEventBus.setCertOptions(serverOptions, this.options.getKeyCertOptions());
        ClusteredEventBus.setTrustOptions(serverOptions, this.options.getTrustOptions());
        return serverOptions;
    }

    static void setCertOptions(TCPSSLOptions options, KeyCertOptions keyCertOptions) {
        if (keyCertOptions == null) {
            return;
        }
        if (keyCertOptions instanceof JksOptions) {
            options.setKeyStoreOptions((JksOptions)keyCertOptions);
        } else if (keyCertOptions instanceof PfxOptions) {
            options.setPfxKeyCertOptions((PfxOptions)keyCertOptions);
        } else {
            options.setPemKeyCertOptions((PemKeyCertOptions)keyCertOptions);
        }
    }

    static void setTrustOptions(TCPSSLOptions sslOptions, TrustOptions options) {
        if (options == null) {
            return;
        }
        if (options instanceof JksOptions) {
            sslOptions.setTrustStoreOptions((JksOptions)options);
        } else if (options instanceof PfxOptions) {
            sslOptions.setPfxTrustOptions((PfxOptions)options);
        } else {
            sslOptions.setPemTrustOptions((PemTrustOptions)options);
        }
    }

    @Override
    public void start(Handler<AsyncResult<Void>> resultHandler) {
        HAManager haManager = this.vertx.haManager();
        this.setClusterViewChangedHandler(haManager);
        this.clusterManager.getAsyncMultiMap(SUBS_MAP_NAME, ar1 -> {
            if (ar1.succeeded()) {
                this.subs = (AsyncMultiMap)ar1.result();
                this.server = this.vertx.createNetServer(this.getServerOptions());
                this.server.connectHandler(this.getServerHandler());
                this.server.listen(asyncResult -> {
                    if (asyncResult.succeeded()) {
                        int serverPort = this.getClusterPublicPort(this.options, this.server.actualPort());
                        String serverHost = this.getClusterPublicHost(this.options);
                        this.serverID = new ServerID(serverPort, serverHost);
                        this.nodeInfo = new ClusterNodeInfo(this.clusterManager.getNodeID(), this.serverID);
                        this.vertx.executeBlocking(fut -> {
                            haManager.addDataToAHAInfo(SERVER_ID_HA_KEY, new JsonObject().put("host", this.serverID.host).put("port", this.serverID.port));
                            fut.complete();
                        }, false, ar2 -> {
                            if (ar2.succeeded()) {
                                this.started = true;
                                resultHandler.handle(Future.succeededFuture());
                            } else {
                                resultHandler.handle(Future.failedFuture(ar2.cause()));
                            }
                        });
                    } else {
                        resultHandler.handle(Future.failedFuture(asyncResult.cause()));
                    }
                });
            } else {
                resultHandler.handle(Future.failedFuture(ar1.cause()));
            }
        });
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        super.close(ar1 -> {
            if (this.server != null) {
                this.server.close(ar -> {
                    if (ar.failed()) {
                        log.error("Failed to close server", ar.cause());
                    }
                    for (ConnectionHolder holder : this.connections.values()) {
                        holder.close();
                    }
                    if (completionHandler != null) {
                        completionHandler.handle((AsyncResult<Void>)ar);
                    }
                });
            } else if (completionHandler != null) {
                completionHandler.handle((AsyncResult<Void>)ar1);
            }
        });
    }

    @Override
    public MessageImpl createMessage(boolean send, String address, MultiMap headers, Object body, String codecName) {
        Objects.requireNonNull(address, "no null address accepted");
        MessageCodec codec = this.codecManager.lookupCodec(body, codecName);
        ClusteredMessage msg = new ClusteredMessage(this.serverID, address, headers, body, codec, send, this);
        return msg;
    }

    @Override
    protected <T> void addRegistration(boolean newAddress, HandlerHolder<T> holder, Handler<AsyncResult<Void>> completionHandler) {
        if (newAddress && this.subs != null && !holder.replyHandler && !holder.localOnly) {
            this.subs.add(holder.address, this.nodeInfo, completionHandler);
            this.ownSubs.add(holder.address);
        } else {
            completionHandler.handle(Future.succeededFuture());
        }
    }

    @Override
    protected <T> void removeRegistration(HandlerHolder<T> lastHolder, String address, Promise<Void> completionHandler) {
        if (lastHolder != null && this.subs != null && !lastHolder.isLocalOnly()) {
            this.ownSubs.remove(address);
            this.removeSub(address, this.nodeInfo, completionHandler);
        } else {
            completionHandler.complete();
        }
    }

    @Override
    protected <T> void sendOrPub(OutboundDeliveryContext<T> sendContext) {
        if (((ClusteredMessage)sendContext.message).getRepliedTo() != null) {
            this.clusteredSendReply(((ClusteredMessage)sendContext.message).getRepliedTo(), sendContext);
        } else if (sendContext.options.isLocalOnly()) {
            super.sendOrPub(sendContext);
        } else if (Vertx.currentContext() != sendContext.ctx) {
            sendContext.ctx.runOnContext(v -> this.subs.get(sendContext.message.address(), ar -> this.onSubsReceived((AsyncResult<ChoosableIterable<ClusterNodeInfo>>)ar, sendContext)));
        } else {
            this.subs.get(sendContext.message.address(), ar -> this.onSubsReceived((AsyncResult<ChoosableIterable<ClusterNodeInfo>>)ar, sendContext));
        }
    }

    private <T> void onSubsReceived(AsyncResult<ChoosableIterable<ClusterNodeInfo>> asyncResult, OutboundDeliveryContext<T> sendContext) {
        if (asyncResult.succeeded()) {
            ChoosableIterable<ClusterNodeInfo> serverIDs = asyncResult.result();
            if (serverIDs != null && !serverIDs.isEmpty()) {
                this.sendToSubs(serverIDs, sendContext);
            } else {
                super.sendOrPub(sendContext);
            }
        } else {
            log.error("Failed to send message", asyncResult.cause());
            sendContext.written(asyncResult.cause());
        }
    }

    @Override
    protected String generateReplyAddress() {
        return "__vertx.reply." + UUID.randomUUID().toString();
    }

    @Override
    protected boolean isMessageLocal(MessageImpl msg) {
        ClusteredMessage clusteredMessage = (ClusteredMessage)msg;
        return !clusteredMessage.isFromWire();
    }

    private void setClusterViewChangedHandler(HAManager haManager) {
        haManager.setClusterViewChangedHandler((Set<String> members) -> {
            this.ownSubs.forEach(address -> this.subs.add((String)address, this.nodeInfo, addResult -> {
                if (addResult.failed()) {
                    log.warn("Failed to update subs map with self", addResult.cause());
                }
            }));
            this.subs.removeAllMatching((Predicate<ClusterNodeInfo> & Serializable)ci -> !members.contains(ci.nodeId), removeResult -> {
                if (removeResult.failed()) {
                    log.warn("Error removing subs", removeResult.cause());
                }
            });
        });
    }

    private int getClusterPublicPort(EventBusOptions options, int actualPort) {
        int publicPort = Integer.getInteger(CLUSTER_PUBLIC_PORT_PROP_NAME, options.getClusterPublicPort());
        if (publicPort == -1) {
            publicPort = actualPort;
        }
        return publicPort;
    }

    private String getClusterPublicHost(EventBusOptions options) {
        String publicHost = System.getProperty(CLUSTER_PUBLIC_HOST_PROP_NAME, options.getClusterPublicHost());
        if (publicHost == null) {
            publicHost = options.getHost();
        }
        return publicHost;
    }

    private Handler<NetSocket> getServerHandler() {
        return socket -> {
            final RecordParser parser = RecordParser.newFixed(4);
            Handler<Buffer> handler = new Handler<Buffer>(){
                int size = -1;

                @Override
                public void handle(Buffer buff) {
                    if (this.size == -1) {
                        this.size = buff.getInt(0);
                        parser.fixedSizeMode(this.size);
                    } else {
                        ClusteredMessage received = new ClusteredMessage(ClusteredEventBus.this);
                        received.readFromWire(buff, ClusteredEventBus.this.codecManager);
                        if (ClusteredEventBus.this.metrics != null) {
                            ClusteredEventBus.this.metrics.messageRead(received.address(), buff.length());
                        }
                        parser.fixedSizeMode(4);
                        this.size = -1;
                        if (received.codec() == CodecManager.PING_MESSAGE_CODEC) {
                            socket.write(PONG);
                        } else {
                            ClusteredEventBus.this.deliverMessageLocally(received);
                        }
                    }
                }
            };
            parser.setOutput(handler);
            socket.handler((Handler)parser);
        };
    }

    private <T> void sendToSubs(ChoosableIterable<ClusterNodeInfo> subs, OutboundDeliveryContext<T> sendContext) {
        if (sendContext.message.isSend()) {
            ServerID sid;
            ClusterNodeInfo ci = subs.choose();
            ServerID serverID = sid = ci == null ? null : ci.serverID;
            if (sid != null && !sid.equals(this.serverID)) {
                this.sendRemote(sendContext, sid, sendContext.message);
            } else {
                super.sendOrPub(sendContext);
            }
        } else {
            for (ClusterNodeInfo ci : subs) {
                if (!ci.serverID.equals(this.serverID)) {
                    this.sendRemote(sendContext, ci.serverID, sendContext.message);
                    continue;
                }
                super.sendOrPub(sendContext);
            }
        }
    }

    private <T> void clusteredSendReply(ServerID replyDest, OutboundDeliveryContext<T> sendContext) {
        MessageImpl message = sendContext.message;
        if (!replyDest.equals(this.serverID)) {
            this.sendRemote(sendContext, replyDest, message);
        } else {
            super.sendOrPub(sendContext);
        }
    }

    private void sendRemote(OutboundDeliveryContext<?> sendContext, ServerID theServerID, MessageImpl message) {
        ConnectionHolder holder = (ConnectionHolder)this.connections.get(theServerID);
        if (holder == null) {
            holder = new ConnectionHolder(this, theServerID, this.options);
            ConnectionHolder prevHolder = this.connections.putIfAbsent(theServerID, holder);
            if (prevHolder != null) {
                holder = prevHolder;
            } else {
                holder.connect();
            }
        }
        holder.writeMessage(sendContext);
    }

    private void removeSub(String subName, ClusterNodeInfo node, Promise<Void> completionHandler) {
        this.subs.remove(subName, node, ar -> {
            if (!ar.succeeded()) {
                log.error("Failed to remove sub", ar.cause());
            } else if (((Boolean)ar.result()).booleanValue()) {
                completionHandler.complete();
            } else {
                completionHandler.fail("sub not found");
            }
        });
    }

    ConcurrentMap<ServerID, ConnectionHolder> connections() {
        return this.connections;
    }

    VertxInternal vertx() {
        return this.vertx;
    }

    EventBusOptions options() {
        return this.options;
    }
}

