/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.Http1xServerResponse;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.NettyFileUpload;
import io.vertx.core.http.impl.NettyFileUploadDataFactory;
import io.vertx.core.http.impl.ServerWebSocketImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.streams.impl.InboundBuffer;
import java.net.URISyntaxException;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public class Http1xServerRequest
implements HttpServerRequest {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerRequest.class);
    private final Http1xServerConnection conn;
    final ContextInternal context;
    private HttpRequest request;
    private HttpVersion version;
    private HttpMethod method;
    private String rawMethod;
    private String uri;
    private String path;
    private String query;
    Http1xServerRequest next;
    Object metric;
    Object trace;
    private Http1xServerResponse response;
    private Handler<Buffer> dataHandler;
    private Handler<Throwable> exceptionHandler;
    private MultiMap params;
    private MultiMap headers;
    private String absoluteURI;
    private Handler<HttpServerFileUpload> uploadHandler;
    private Handler<Void> endHandler;
    private MultiMap attributes;
    private HttpPostRequestDecoder decoder;
    private boolean ended;
    private long bytesRead;
    private InboundBuffer<Object> pending;
    private Buffer body;
    private Promise<Buffer> bodyPromise;

    Http1xServerRequest(Http1xServerConnection conn, HttpRequest request) {
        this.conn = conn;
        this.context = conn.getContext().duplicate();
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpRequest nettyRequest() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequest(HttpRequest request) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.request = request;
        }
    }

    private InboundBuffer<Object> pendingQueue() {
        if (this.pending == null) {
            this.pending = new InboundBuffer(this.conn.getContext(), 8L);
            this.pending.drainHandler(v -> this.conn.doResume());
            this.pending.handler((E buffer) -> {
                if (buffer == InboundBuffer.END_SENTINEL) {
                    this.onEnd();
                } else {
                    this.onData((Buffer)buffer);
                }
            });
        }
        return this.pending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleContent(Buffer buffer) {
        InboundBuffer<Object> queue;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            queue = this.pending;
        }
        if (queue != null) {
            if (!queue.write(buffer)) {
                this.conn.doPause();
            }
        } else {
            this.onData(buffer);
        }
    }

    void handleBegin() {
        this.response = new Http1xServerResponse((VertxInternal)this.conn.vertx(), this.context, this.conn, this.request, this.metric);
        if (this.conn.handle100ContinueAutomatically) {
            this.check100();
        }
    }

    void enqueue(Http1xServerRequest request) {
        Http1xServerRequest current = this;
        while (current.next != null) {
            current = current.next;
        }
        current.next = request;
    }

    Http1xServerRequest next() {
        return this.next;
    }

    private void check100() {
        if (HttpUtil.is100ContinueExpected((HttpMessage)this.request)) {
            this.conn.write100Continue();
        }
    }

    Object metric() {
        return this.metric;
    }

    Object trace() {
        return this.trace;
    }

    @Override
    public HttpVersion version() {
        if (this.version == null) {
            io.netty.handler.codec.http.HttpVersion nettyVersion = this.request.protocolVersion();
            if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_0) {
                this.version = HttpVersion.HTTP_1_0;
            } else if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                this.version = HttpVersion.HTTP_1_1;
            } else {
                this.sendNotImplementedAndClose();
                throw new IllegalStateException("Unsupported HTTP version: " + nettyVersion);
            }
        }
        return this.version;
    }

    @Override
    public HttpMethod method() {
        if (this.method == null) {
            String sMethod = this.request.method().toString();
            try {
                this.method = HttpMethod.valueOf(sMethod);
            }
            catch (IllegalArgumentException e) {
                this.method = HttpMethod.OTHER;
            }
        }
        return this.method;
    }

    @Override
    public String rawMethod() {
        if (this.rawMethod == null) {
            this.rawMethod = this.request.method().toString();
        }
        return this.rawMethod;
    }

    @Override
    public String uri() {
        if (this.uri == null) {
            this.uri = this.request.uri();
        }
        return this.uri;
    }

    @Override
    public String path() {
        if (this.path == null) {
            this.path = HttpUtils.parsePath(this.uri());
        }
        return this.path;
    }

    @Override
    public String query() {
        if (this.query == null) {
            this.query = HttpUtils.parseQuery(this.uri());
        }
        return this.query;
    }

    @Override
    public @Nullable String host() {
        return this.getHeader((CharSequence)HttpHeaderNames.HOST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bytesRead() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.bytesRead;
        }
    }

    @Override
    public Http1xServerResponse response() {
        return this.response;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            HttpHeaders reqHeaders = this.request.headers();
            this.headers = reqHeaders instanceof MultiMap ? (MultiMap)reqHeaders : new HeadersAdaptor(reqHeaders);
        }
        return this.headers;
    }

    @Override
    public MultiMap params() {
        if (this.params == null) {
            this.params = HttpUtils.params(this.uri());
        }
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.dataHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest pause() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.pendingQueue().pause();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest fetch(long amount) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.pendingQueue().fetch(amount);
            return this;
        }
    }

    @Override
    public HttpServerRequest resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.endHandler = handler;
            return this;
        }
    }

    @Override
    public String scheme() {
        return this.isSSL() ? "https" : "http";
    }

    @Override
    public String absoluteURI() {
        if (this.absoluteURI == null) {
            try {
                this.absoluteURI = HttpUtils.absoluteURI(this.conn.getServerOrigin(), this);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Failed to create abs uri", e);
            }
        }
        return this.absoluteURI;
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket netSocket() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.response.netSocket(this.method() == HttpMethod.CONNECT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.uploadHandler = handler;
            return this;
        }
    }

    @Override
    public MultiMap formAttributes() {
        return this.attributes();
    }

    @Override
    public String getFormAttribute(String attributeName) {
        return this.formAttributes().get(attributeName);
    }

    @Override
    public ServerWebSocket upgrade() {
        ServerWebSocketImpl ws = this.conn.createWebSocket(this);
        if (ws == null) {
            throw new IllegalStateException("Can't upgrade this request");
        }
        ws.accept();
        return ws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest setExpectMultipart(boolean expect) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkEnded();
            if (expect) {
                String contentType;
                if (this.decoder == null && (contentType = this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null) {
                    io.netty.handler.codec.http.HttpMethod method = this.request.method();
                    if (this.isValidMultipartContentType(contentType) && this.isValidMultipartMethod(method)) {
                        this.decoder = new HttpPostRequestDecoder((HttpDataFactory)new NettyFileUploadDataFactory(this.conn.getContext(), this, () -> this.uploadHandler), this.request);
                    }
                }
            } else {
                this.decoder = null;
            }
            return this;
        }
    }

    private boolean isValidMultipartContentType(String contentType) {
        return HttpHeaderValues.MULTIPART_FORM_DATA.regionMatches(true, 0, (CharSequence)contentType, 0, HttpHeaderValues.MULTIPART_FORM_DATA.length()) || HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.regionMatches(true, 0, (CharSequence)contentType, 0, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.length());
    }

    private boolean isValidMultipartMethod(io.netty.handler.codec.http.HttpMethod method) {
        return method.equals((Object)io.netty.handler.codec.http.HttpMethod.POST) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.PUT) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.PATCH) || method.equals((Object)io.netty.handler.codec.http.HttpMethod.DELETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpectMultipart() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.decoder != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnded() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.ended && (this.pending == null || !this.pending.isPaused() && this.pending.isEmpty());
        }
    }

    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    @Override
    public synchronized Future<Buffer> body() {
        if (this.bodyPromise == null) {
            this.bodyPromise = Promise.promise();
            this.body = Buffer.buffer();
        }
        return this.bodyPromise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onData(Buffer data) {
        Handler<Buffer> handler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.bytesRead += (long)data.length();
            if (this.decoder != null) {
                try {
                    this.decoder.offer((HttpContent)new DefaultHttpContent(data.getByteBuf()));
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                    this.handleException(e);
                }
            }
            handler = this.dataHandler;
            if (this.body != null) {
                this.body.appendBuffer(data);
            }
        }
        if (handler != null) {
            handler.handle(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd() {
        InboundBuffer<Object> queue;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.ended = true;
            queue = this.pending;
        }
        if (queue != null) {
            queue.write(InboundBuffer.END_SENTINEL);
        } else {
            this.onEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnd() {
        Buffer body;
        Promise<Buffer> bodyPromise;
        Handler<Void> handler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.decoder != null) {
                this.endDecode();
            }
            handler = this.endHandler;
            bodyPromise = this.bodyPromise;
            body = this.body;
        }
        if (handler != null) {
            handler.handle(null);
        }
        if (body != null) {
            bodyPromise.tryComplete(body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endDecode() {
        try {
            this.decoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
            while (this.decoder.hasNext()) {
                InterfaceHttpData data = this.decoder.next();
                if (!(data instanceof Attribute)) continue;
                Attribute attr = (Attribute)data;
                try {
                    this.attributes().add(attr.getName(), attr.getValue());
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            this.handleException(e);
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
        }
        finally {
            this.decoder.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        Promise<Buffer> bodyPromise;
        Handler<Throwable> handler = null;
        Http1xServerResponse resp = null;
        InterfaceHttpData upload = null;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (!this.isEnded()) {
                handler = this.exceptionHandler;
                if (this.decoder != null) {
                    upload = this.decoder.currentPartialHttpData();
                }
            }
            if (!this.response.ended()) {
                if (Metrics.METRICS_ENABLED) {
                    this.reportRequestReset(t);
                }
                resp = this.response;
            }
            bodyPromise = this.bodyPromise;
            this.bodyPromise = null;
            this.body = null;
        }
        if (resp != null) {
            resp.handleException(t);
        }
        if (upload instanceof NettyFileUpload) {
            ((NettyFileUpload)upload).handleException(t);
        }
        if (handler != null) {
            handler.handle(t);
        }
        if (bodyPromise != null) {
            bodyPromise.tryFail(t);
        }
    }

    private void reportRequestReset(Throwable err) {
        VertxTracer tracer;
        if (this.conn.metrics != null) {
            this.conn.metrics.requestReset(this.metric);
        }
        if ((tracer = this.context.tracer()) != null) {
            tracer.sendResponse(this.context, null, this.trace, err, TagExtractor.empty());
        }
    }

    private void sendNotImplementedAndClose() {
        this.response().setStatusCode(501).end();
        this.response().close();
    }

    private void checkEnded() {
        if (this.isEnded()) {
            throw new IllegalStateException("Request has already been read");
        }
    }

    private MultiMap attributes() {
        if (this.attributes == null) {
            this.attributes = new CaseInsensitiveHeaders();
        }
        return this.attributes;
    }

    @Override
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        return this;
    }

    @Override
    public Map<String, Cookie> cookieMap() {
        return this.response.cookies();
    }
}

