/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http2ClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.net.SocketAddress;

class HttpClientRequestPushPromise
extends HttpClientRequestBase {
    private final Http2ClientConnection conn;
    private final Http2ClientConnection.StreamImpl stream;
    private final String rawMethod;
    private final MultiMap headers;

    public HttpClientRequestPushPromise(Http2ClientConnection conn, HttpClientImpl client, boolean ssl, HttpMethod method, String rawMethod, String uri, String host, int port, MultiMap headers) {
        super(client, conn.getContext(), ssl, method, SocketAddress.inetSocketAddress(port, host), host, port, uri);
        this.conn = conn;
        this.stream = new Http2ClientConnection.StreamImpl(conn, conn.getContext(), this, null);
        this.rawMethod = rawMethod;
        this.headers = headers;
    }

    Http2ClientConnection.StreamImpl getStream() {
        return this.stream;
    }

    @Override
    void handleResponse(HttpClientResponse resp, long timeoutMs) {
        this.responsePromise.complete(resp);
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    @Override
    boolean reset(Throwable cause) {
        this.stream.reset(cause);
        return true;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String getRawMethod() {
        return this.rawMethod;
    }

    @Override
    public HttpClientRequest setRawMethod(String method) {
        throw new IllegalStateException();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String getHost() {
        return this.server.host();
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public Future<Void> write(Buffer data) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest drainHandler(Handler<Void> handler) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest setFollowRedirects(boolean followRedirect) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest setChunked(boolean chunked) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest setHost(String host) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest putHeader(String name, String value) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        throw new IllegalStateException();
    }

    @Override
    public Future<Void> write(String chunk) {
        throw new IllegalStateException();
    }

    @Override
    public Future<Void> write(String chunk, String enc) {
        throw new IllegalStateException();
    }

    @Override
    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public void write(String chunk, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public void write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest continueHandler(@Nullable Handler<Void> handler) {
        throw new IllegalStateException();
    }

    @Override
    public Future<HttpVersion> sendHead() {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest sendHead(Handler<AsyncResult<HttpVersion>> completionHandler) {
        throw new IllegalStateException();
    }

    @Override
    public Future<Void> end(String chunk) {
        throw new IllegalStateException();
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public Future<Void> end(String chunk, String enc) {
        throw new IllegalStateException();
    }

    @Override
    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public Future<Void> end(Buffer chunk) {
        throw new IllegalStateException();
    }

    @Override
    public void end(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        throw new IllegalStateException();
    }

    @Override
    public Future<Void> end() {
        throw new IllegalStateException();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public boolean writeQueueFull() {
        throw new IllegalStateException();
    }

    @Override
    public StreamPriority getStreamPriority() {
        return this.stream.priority();
    }

    @Override
    public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        throw new UnsupportedOperationException("Cannot write frame with HTTP/1.x ");
    }
}

