/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.http.impl.WebSocketRequestHandler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.ConnectionBase;
import java.util.ArrayList;
import java.util.Objects;

public class HttpHandlers
implements Handler<HttpServerConnection> {
    final HttpServerImpl server;
    final Handler<HttpServerRequest> requestHandler;
    final Handler<ServerWebSocket> wsHandler;
    final Handler<HttpConnection> connectionHandler;
    final Handler<Throwable> exceptionHandler;

    public HttpHandlers(HttpServerImpl server, Handler<HttpServerRequest> requestHandler, Handler<ServerWebSocket> wsHandler, Handler<HttpConnection> connectionHandler, Handler<Throwable> exceptionHandler) {
        this.server = server;
        this.requestHandler = requestHandler;
        this.wsHandler = wsHandler;
        this.connectionHandler = connectionHandler;
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServerConnection conn) {
        this.server.connectionMap.put(conn.channel(), (ConnectionBase)((Object)conn));
        conn.channel().closeFuture().addListener(fut -> this.server.connectionMap.remove(conn.channel()));
        WebSocketRequestHandler requestHandler = this.requestHandler;
        if (!HttpServerImpl.DISABLE_WEBSOCKETS && conn instanceof Http1xServerConnection) {
            requestHandler = new WebSocketRequestHandler(this.server.metrics, this);
            Http1xServerConnection c = (Http1xServerConnection)conn;
            this.initializeWebsocketExtensions(c.channelHandlerContext().pipeline());
        }
        conn.exceptionHandler(this.exceptionHandler);
        conn.handler(requestHandler);
        if (this.connectionHandler != null) {
            ContextInternal ctx = conn.getContext();
            ContextInternal prev = ctx.beginEmission();
            try {
                this.connectionHandler.handle(conn);
            }
            catch (Exception e) {
                ctx.reportException(e);
            }
            finally {
                ctx.endEmission(prev);
            }
        }
    }

    private void initializeWebsocketExtensions(ChannelPipeline pipeline) {
        ArrayList<Object> extensionHandshakers = new ArrayList<Object>();
        if (this.server.options.getPerFrameWebsocketCompressionSupported()) {
            extensionHandshakers.add(new DeflateFrameServerExtensionHandshaker(this.server.options.getWebsocketCompressionLevel()));
        }
        if (this.server.options.getPerMessageWebsocketCompressionSupported()) {
            extensionHandshakers.add(new PerMessageDeflateServerExtensionHandshaker(this.server.options.getWebsocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, this.server.options.getWebsocketAllowServerNoContext(), this.server.options.getWebsocketPreferredClientNoContext()));
        }
        if (!extensionHandshakers.isEmpty()) {
            WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(extensionHandshakers.toArray(new WebSocketServerExtensionHandshaker[extensionHandshakers.size()]));
            pipeline.addBefore("handler", "websocketExtensionHandler", (ChannelHandler)extensionHandler);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHandlers that = (HttpHandlers)o;
        if (!Objects.equals(this.requestHandler, that.requestHandler)) {
            return false;
        }
        if (!Objects.equals(this.wsHandler, that.wsHandler)) {
            return false;
        }
        if (!Objects.equals(this.connectionHandler, that.connectionHandler)) {
            return false;
        }
        return Objects.equals(this.exceptionHandler, that.exceptionHandler);
    }

    public int hashCode() {
        int result = 0;
        if (this.requestHandler != null) {
            result = 31 * result + this.requestHandler.hashCode();
        }
        if (this.wsHandler != null) {
            result = 31 * result + this.wsHandler.hashCode();
        }
        if (this.connectionHandler != null) {
            result = 31 * result + this.connectionHandler.hashCode();
        }
        if (this.exceptionHandler != null) {
            result = 31 * result + this.exceptionHandler.hashCode();
        }
        return result;
    }
}

