/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.ServiceHelper;
import io.vertx.core.Verticle;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DeploymentManager;
import io.vertx.core.impl.IsolatingClassLoader;
import io.vertx.core.impl.JavaVerticleFactory;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.VerticleFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class VerticleManager {
    private final VertxInternal vertx;
    private final DeploymentManager deploymentManager;
    private final Map<String, IsolatingClassLoader> classloaders = new HashMap<String, IsolatingClassLoader>();
    private final Map<String, List<VerticleFactory>> verticleFactories = new ConcurrentHashMap<String, List<VerticleFactory>>();
    private final List<VerticleFactory> defaultFactories = new ArrayList<VerticleFactory>();

    public VerticleManager(VertxInternal vertx, DeploymentManager deploymentManager) {
        this.vertx = vertx;
        this.deploymentManager = deploymentManager;
        this.loadVerticleFactories();
    }

    private void loadVerticleFactories() {
        Collection<VerticleFactory> factories = ServiceHelper.loadFactories(VerticleFactory.class);
        factories.forEach(this::registerVerticleFactory);
        JavaVerticleFactory defaultFactory = new JavaVerticleFactory();
        defaultFactory.init(this.vertx);
        this.defaultFactories.add(defaultFactory);
    }

    public void registerVerticleFactory(VerticleFactory factory) {
        String prefix = factory.prefix();
        if (prefix == null) {
            throw new IllegalArgumentException("factory.prefix() cannot be null");
        }
        List<VerticleFactory> facts = this.verticleFactories.get(prefix);
        if (facts == null) {
            facts = new ArrayList<VerticleFactory>();
            this.verticleFactories.put(prefix, facts);
        }
        if (facts.contains(factory)) {
            throw new IllegalArgumentException("Factory already registered");
        }
        facts.add(factory);
        facts.sort((fact1, fact2) -> fact1.order() - fact2.order());
        factory.init(this.vertx);
    }

    public void unregisterVerticleFactory(VerticleFactory factory) {
        String prefix = factory.prefix();
        if (prefix == null) {
            throw new IllegalArgumentException("factory.prefix() cannot be null");
        }
        List<VerticleFactory> facts = this.verticleFactories.get(prefix);
        boolean removed = false;
        if (facts != null) {
            if (facts.remove(factory)) {
                removed = true;
            }
            if (facts.isEmpty()) {
                this.verticleFactories.remove(prefix);
            }
        }
        if (!removed) {
            throw new IllegalArgumentException("factory isn't registered");
        }
    }

    public Set<VerticleFactory> verticleFactories() {
        HashSet<VerticleFactory> facts = new HashSet<VerticleFactory>();
        for (List<VerticleFactory> list : this.verticleFactories.values()) {
            facts.addAll(list);
        }
        return facts;
    }

    private List<VerticleFactory> resolveFactories(String identifier) {
        List<VerticleFactory> factoryList = null;
        int pos = identifier.indexOf(58);
        String lookup = null;
        if (pos != -1) {
            lookup = identifier.substring(0, pos);
        } else {
            pos = identifier.lastIndexOf(46);
            if (pos != -1) {
                lookup = VerticleManager.getSuffix(pos, identifier);
            } else {
                factoryList = this.defaultFactories;
            }
        }
        if (factoryList == null && (factoryList = this.verticleFactories.get(lookup)) == null) {
            factoryList = this.defaultFactories;
        }
        return factoryList;
    }

    private static String getSuffix(int pos, String str) {
        if (pos + 1 >= str.length()) {
            throw new IllegalArgumentException("Invalid name: " + str);
        }
        return str.substring(pos + 1);
    }

    public Future<Deployment> deployVerticle(String identifier, DeploymentOptions options) {
        ContextInternal callingContext = this.vertx.getOrCreateContext();
        ClassLoader cl = this.getClassLoader(options);
        return this.doDeployVerticle(identifier, options, callingContext, callingContext, cl);
    }

    private Future<Deployment> doDeployVerticle(String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl) {
        List<VerticleFactory> verticleFactories = this.resolveFactories(identifier);
        Iterator<VerticleFactory> iter = verticleFactories.iterator();
        return this.doDeployVerticle(iter, null, identifier, options, parentContext, callingContext, cl);
    }

    private Future<Deployment> doDeployVerticle(Iterator<VerticleFactory> iter, Throwable prevErr, String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl) {
        if (iter.hasNext()) {
            VerticleFactory verticleFactory = iter.next();
            PromiseInternal<String> promise = callingContext.promise();
            if (verticleFactory.requiresResolve()) {
                try {
                    verticleFactory.resolve(identifier, options, cl, promise);
                }
                catch (Exception e) {
                    try {
                        promise.fail(e);
                    }
                    catch (Exception exception) {}
                }
            } else {
                promise.complete(identifier);
            }
            return promise.future().compose(resolvedName -> {
                if (!resolvedName.equals(identifier)) {
                    return this.deployVerticle((String)resolvedName, options);
                }
                Promise<Callable<Verticle>> p = Promise.promise();
                try {
                    verticleFactory.createVerticle(identifier, cl, p);
                }
                catch (Exception e) {
                    return Future.failedFuture(e);
                }
                Future fut = p.future().compose(callable -> this.deploymentManager.doDeploy(options, v -> identifier, parentContext, callingContext, cl, (Callable<Verticle>)callable));
                String group = options.getIsolationGroup();
                if (group != null) {
                    fut.setHandler(ar -> {
                        if (!ar.succeeded()) {
                            throw new UnsupportedOperationException();
                        }
                        Deployment result = (Deployment)ar.result();
                        result.getContexts().forEach(ctx -> ctx.addCloseHook(hook -> {
                            VerticleManager verticleManager = this;
                            synchronized (verticleManager) {
                                IsolatingClassLoader icl = this.classloaders.get(group);
                                if (--icl.refCount == 0) {
                                    this.classloaders.remove(group);
                                    try {
                                        icl.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                            hook.complete();
                        }));
                    });
                }
                return fut;
            }).recover(err -> this.doDeployVerticle(iter, (Throwable)err, identifier, options, parentContext, callingContext, cl));
        }
        if (prevErr != null) {
            return callingContext.failedFuture(prevErr);
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader(DeploymentOptions options) {
        ClassLoader cl;
        String isolationGroup = options.getIsolationGroup();
        if (isolationGroup == null) {
            cl = this.getCurrentClassLoader();
        } else {
            VerticleManager verticleManager = this;
            synchronized (verticleManager) {
                IsolatingClassLoader icl = this.classloaders.get(isolationGroup);
                if (icl == null) {
                    ClassLoader current = this.getCurrentClassLoader();
                    if (!(current instanceof URLClassLoader)) {
                        throw new IllegalStateException("Current classloader must be URLClassLoader");
                    }
                    ArrayList<URL> urls = new ArrayList<URL>();
                    List<String> extraClasspath = options.getExtraClasspath();
                    if (extraClasspath != null) {
                        for (String pathElement : extraClasspath) {
                            File file = new File(pathElement);
                            try {
                                URL url = file.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                    }
                    URLClassLoader urlc = (URLClassLoader)current;
                    urls.addAll(Arrays.asList(urlc.getURLs()));
                    icl = new IsolatingClassLoader(urls.toArray(new URL[urls.size()]), this.getCurrentClassLoader(), options.getIsolatedClasses());
                    this.classloaders.put(isolationGroup, icl);
                }
                icl.refCount += options.getInstances();
                cl = icl;
            }
        }
        return cl;
    }

    private ClassLoader getCurrentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }
}

