/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.AbstractContext;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.Objects;

class WorkerContext
extends ContextImpl {
    WorkerContext(VertxInternal vertx, VertxTracer<?, ?> tracer, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, ClassLoader tccl) {
        super(vertx, tracer, internalBlockingPool, workerPool, deployment, tccl);
    }

    @Override
    <T> void execute(T argument, Handler<T> task) {
        this.execute(this, this.orderedTasks, argument, task);
    }

    @Override
    public void execute(Runnable task) {
        this.execute(this, this.orderedTasks, task);
    }

    @Override
    public boolean isEventLoopContext() {
        return false;
    }

    @Override
    public <T> void dispatchFromIO(T argument, Handler<T> task) {
        if (THREAD_CHECKS) {
            WorkerContext.checkEventLoopThread();
        }
        this.execute(argument, task);
    }

    @Override
    public <T> void dispatch(T argument, Handler<T> task) {
        WorkerContext.dispatch(this, argument, task);
    }

    private static <T> void dispatch(AbstractContext ctx, T value, Handler<T> task) {
        if (AbstractContext.context() == ctx) {
            ctx.emit(value, task);
        } else if (ctx.nettyEventLoop().inEventLoop()) {
            ctx.dispatchFromIO(value, task);
        } else {
            ctx.execute(value, task);
        }
    }

    private <T> void execute(ContextInternal ctx, TaskQueue queue, Runnable task) {
        PoolMetrics metrics = this.workerPool.metrics();
        Object queueMetric = metrics != null ? metrics.submitted() : null;
        queue.execute(() -> {
            Object execMetric = null;
            if (metrics != null) {
                execMetric = metrics.begin(queueMetric);
            }
            try {
                ctx.emit(task);
            }
            finally {
                if (metrics != null) {
                    metrics.end(execMetric, true);
                }
            }
        }, this.workerPool.executor());
    }

    private <T> void execute(ContextInternal ctx, TaskQueue queue, T value, Handler<T> task) {
        Objects.requireNonNull(task, "Task handler must not be null");
        PoolMetrics metrics = this.workerPool.metrics();
        Object queueMetric = metrics != null ? metrics.submitted() : null;
        queue.execute(() -> {
            Object execMetric = null;
            if (metrics != null) {
                execMetric = metrics.begin(queueMetric);
            }
            try {
                ctx.emit(value, task);
            }
            finally {
                if (metrics != null) {
                    metrics.end(execMetric, true);
                }
            }
        }, this.workerPool.executor());
    }

    @Override
    public <T> void schedule(T argument, Handler<T> task) {
        PoolMetrics metrics = this.workerPool.metrics();
        Object metric = metrics != null ? metrics.submitted() : null;
        this.orderedTasks.execute(() -> {
            if (metrics != null) {
                metrics.begin(metric);
            }
            try {
                task.handle(argument);
            }
            finally {
                if (metrics != null) {
                    metrics.end(metric, true);
                }
            }
        }, this.workerPool.executor());
    }

    @Override
    public ContextInternal duplicate(ContextInternal in) {
        return new Duplicated(this, in);
    }

    static class Duplicated
    extends ContextImpl.Duplicated<WorkerContext> {
        final TaskQueue orderedTasks = new TaskQueue();

        Duplicated(WorkerContext delegate, ContextInternal other) {
            super(delegate, other);
        }

        @Override
        <T> void execute(T argument, Handler<T> task) {
            ((WorkerContext)this.delegate).execute(this, this.orderedTasks, argument, task);
        }

        @Override
        public void execute(Runnable task) {
            ((WorkerContext)this.delegate).execute(this, this.orderedTasks, task);
        }

        @Override
        public final <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action) {
            return ContextImpl.executeBlocking(this, action, ((WorkerContext)this.delegate).internalBlockingPool, ((WorkerContext)this.delegate).internalOrderedTasks);
        }

        @Override
        public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
            return ContextImpl.executeBlocking(this, blockingCodeHandler, ((WorkerContext)this.delegate).workerPool, ordered ? this.orderedTasks : null);
        }

        @Override
        public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue) {
            return ContextImpl.executeBlocking(this, blockingCodeHandler, ((WorkerContext)this.delegate).workerPool, queue);
        }

        @Override
        public <T> void dispatchFromIO(T argument, Handler<T> task) {
            this.execute(argument, task);
        }

        @Override
        public <T> void dispatch(T argument, Handler<T> task) {
            WorkerContext cfr_ignored_0 = (WorkerContext)this.delegate;
            WorkerContext.dispatch(this, argument, task);
        }

        @Override
        public boolean isEventLoopContext() {
            return false;
        }

        @Override
        public ContextInternal duplicate(ContextInternal context) {
            return new Duplicated((WorkerContext)this.delegate, context);
        }
    }
}

