/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JsonObject
implements Iterable<Map.Entry<String, Object>>,
ClusterSerializable,
Shareable {
    private Map<String, Object> map;

    public JsonObject(String json) {
        if (json == null) {
            throw new NullPointerException();
        }
        this.fromJson(json);
        if (this.map == null) {
            throw new DecodeException("Invalid JSON object: " + json);
        }
    }

    public JsonObject() {
        this.map = new LinkedHashMap<String, Object>();
    }

    public JsonObject(Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        this.map = map;
    }

    public JsonObject(Buffer buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        this.fromBuffer(buf);
        if (this.map == null) {
            throw new DecodeException("Invalid JSON object: " + buf);
        }
    }

    public static JsonObject mapFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        return new JsonObject(Json.CODEC.fromValue(obj, Map.class));
    }

    public <T> T mapTo(Class<T> type) {
        return Json.CODEC.fromValue(this.map, type);
    }

    public String getString(String key) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof CharSequence) {
            return val.toString();
        }
        if (val instanceof Instant) {
            return DateTimeFormatter.ISO_INSTANT.format((Instant)val);
        }
        if (val instanceof byte[]) {
            return JsonUtil.BASE64_ENCODER.encodeToString((byte[])val);
        }
        if (val instanceof Enum) {
            return ((Enum)val).name();
        }
        throw new ClassCastException("class " + val.getClass().getName() + " cannot be cast to class java.lang.String");
    }

    public Integer getInteger(String key) {
        Objects.requireNonNull(key);
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public Long getLong(String key) {
        Objects.requireNonNull(key);
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    public Double getDouble(String key) {
        Objects.requireNonNull(key);
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public Float getFloat(String key) {
        Objects.requireNonNull(key);
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Float) {
            return (Float)number;
        }
        return Float.valueOf(number.floatValue());
    }

    public Boolean getBoolean(String key) {
        Objects.requireNonNull(key);
        return (Boolean)this.map.get(key);
    }

    public JsonObject getJsonObject(String key) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        if (val instanceof Map) {
            val = new JsonObject((Map)val);
        }
        return (JsonObject)val;
    }

    public JsonArray getJsonArray(String key) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        if (val instanceof List) {
            val = new JsonArray((List)val);
        }
        return (JsonArray)val;
    }

    public byte[] getBinary(String key) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        String encoded = (String)val;
        return JsonUtil.BASE64_DECODER.decode(encoded);
    }

    public Instant getInstant(String key) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Instant) {
            return (Instant)val;
        }
        String encoded = (String)val;
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(encoded));
    }

    public Object getValue(String key) {
        Objects.requireNonNull(key);
        return JsonUtil.wrapJsonValue(this.map.get(key));
    }

    public String getString(String key, String def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getString(key);
        }
        return def;
    }

    public Integer getInteger(String key, Integer def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getInteger(key);
        }
        return def;
    }

    public Long getLong(String key, Long def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getLong(key);
        }
        return def;
    }

    public Double getDouble(String key, Double def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getDouble(key);
        }
        return def;
    }

    public Float getFloat(String key, Float def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getFloat(key);
        }
        return def;
    }

    public Boolean getBoolean(String key, Boolean def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getBoolean(key);
        }
        return def;
    }

    public JsonObject getJsonObject(String key, JsonObject def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getJsonObject(key);
        }
        return def;
    }

    public JsonArray getJsonArray(String key, JsonArray def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getJsonArray(key);
        }
        return def;
    }

    public byte[] getBinary(String key, byte[] def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getBinary(key);
        }
        return def;
    }

    public Instant getInstant(String key, Instant def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getInstant(key);
        }
        return def;
    }

    public Object getValue(String key, Object def) {
        Objects.requireNonNull(key);
        if (this.map.containsKey(key)) {
            return this.getValue(key);
        }
        return def;
    }

    public boolean containsKey(String key) {
        Objects.requireNonNull(key);
        return this.map.containsKey(key);
    }

    public Set<String> fieldNames() {
        return this.map.keySet();
    }

    public JsonObject putNull(String key) {
        Objects.requireNonNull(key);
        this.map.put(key, null);
        return this;
    }

    public JsonObject put(String key, Object value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public Object remove(String key) {
        Objects.requireNonNull(key);
        return JsonUtil.wrapJsonValue(this.map.remove(key));
    }

    public JsonObject mergeIn(JsonObject other) {
        return this.mergeIn(other, false);
    }

    public JsonObject mergeIn(JsonObject other, boolean deep) {
        return this.mergeIn(other, deep ? Integer.MAX_VALUE : 1);
    }

    public JsonObject mergeIn(JsonObject other, int depth) {
        if (depth < 1) {
            return this;
        }
        if (depth == 1) {
            this.map.putAll(other.map);
            return this;
        }
        for (Map.Entry<String, Object> e : other.map.entrySet()) {
            if (e.getValue() == null) {
                this.map.put(e.getKey(), null);
                continue;
            }
            this.map.merge(e.getKey(), e.getValue(), (oldVal, newVal) -> {
                if (oldVal instanceof Map) {
                    oldVal = new JsonObject((Map)oldVal);
                }
                if (newVal instanceof Map) {
                    newVal = new JsonObject((Map)newVal);
                }
                if (oldVal instanceof JsonObject && newVal instanceof JsonObject) {
                    return ((JsonObject)oldVal).mergeIn((JsonObject)newVal, depth - 1);
                }
                return newVal;
            });
        }
        return this;
    }

    public String encode() {
        return Json.CODEC.toString(this, false);
    }

    public String encodePrettily() {
        return Json.CODEC.toString(this, true);
    }

    public Buffer toBuffer() {
        return Json.CODEC.toBuffer(this, false);
    }

    @Override
    public JsonObject copy() {
        HashMap copiedMap = this.map instanceof LinkedHashMap ? new LinkedHashMap(this.map.size()) : new HashMap(this.map.size());
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object val = JsonUtil.checkAndCopy(entry.getValue());
            copiedMap.put((String)entry.getKey(), (Object)val);
        }
        return new JsonObject(copiedMap);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public Stream<Map.Entry<String, Object>> stream() {
        return JsonObject.asStream(this.iterator());
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new Iter(this.map.entrySet().iterator());
    }

    public int size() {
        return this.map.size();
    }

    @Fluent
    public JsonObject clear() {
        this.map.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject other = (JsonObject)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (String key : this.map.keySet()) {
            Object otherValue;
            if (!other.containsKey(key)) {
                return false;
            }
            Object thisValue = this.getValue(key);
            if (thisValue == (otherValue = other.getValue(key))) continue;
            if (thisValue instanceof Number && otherValue instanceof Number && thisValue.getClass() != otherValue.getClass()) {
                Number n1 = (Number)thisValue;
                Number n2 = (Number)otherValue;
                if ((thisValue instanceof Float || thisValue instanceof Double || otherValue instanceof Float || otherValue instanceof Double) && n1.doubleValue() == n2.doubleValue() || (thisValue instanceof Integer || thisValue instanceof Long || otherValue instanceof Integer || otherValue instanceof Long) && n1.longValue() == n2.longValue()) continue;
            }
            if (thisValue instanceof CharSequence && otherValue instanceof CharSequence && thisValue.getClass() != otherValue.getClass()) {
                CharSequence s1 = (CharSequence)thisValue;
                CharSequence s2 = (CharSequence)otherValue;
                if (Objects.equals(s1.toString(), s2.toString())) continue;
            }
            if (Objects.equals(thisValue, otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        String encoded = this.encode();
        byte[] bytes = encoded.getBytes(StandardCharsets.UTF_8);
        buffer.appendInt(bytes.length);
        buffer.appendBytes(bytes);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        int start = pos + 4;
        String encoded = buffer.getString(start, start + length);
        this.fromJson(encoded);
        return pos + length + 4;
    }

    private void fromJson(String json) {
        this.map = Json.CODEC.fromString(json, Map.class);
    }

    private void fromBuffer(Buffer buf) {
        this.map = Json.CODEC.fromBuffer(buf, Map.class);
    }

    static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private static final class Entry
    implements Map.Entry<String, Object> {
        final String key;
        final Object value;

        public Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Iter
    implements Iterator<Map.Entry<String, Object>> {
        final Iterator<Map.Entry<String, Object>> mapIter;

        Iter(Iterator<Map.Entry<String, Object>> mapIter) {
            this.mapIter = mapIter;
        }

        @Override
        public boolean hasNext() {
            return this.mapIter.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Object wrapped;
            Map.Entry<String, Object> entry = this.mapIter.next();
            Object val = entry.getValue();
            if (val != (wrapped = JsonUtil.wrapJsonValue(val))) {
                return new Entry(entry.getKey(), wrapped);
            }
            return entry;
        }

        @Override
        public void remove() {
            this.mapIter.remove();
        }
    }
}

