/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HttpClientRequestImpl
extends HttpClientRequestBase
implements HttpClientRequest {
    static final Logger log = LoggerFactory.getLogger(HttpClientRequestImpl.class);
    private final Promise<Void> endPromise = this.context.promise();
    private final Future<Void> endFuture = this.endPromise.future();
    private boolean chunked = false;
    private String authority;
    private Handler<Void> continueHandler;
    private Handler<Void> drainHandler;
    private Handler<HttpClientRequest> pushHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean ended;
    private Throwable reset;
    private ByteBuf pendingChunks;
    private List<Handler<AsyncResult<Void>>> pendingHandlers;
    private int pendingMaxSize = -1;
    private int followRedirects;
    private VertxHttpHeaders headers;
    private StreamPriority priority = HttpUtils.DEFAULT_STREAM_PRIORITY;
    private HttpClientStream stream;
    private boolean connecting;
    private Promise<NetSocket> netSocketPromise;

    HttpClientRequestImpl(HttpClientImpl client, PromiseInternal<HttpClientResponse> responsePromise, boolean ssl, HttpMethod method, SocketAddress server, String host, int port, String requestURI) {
        super(client, responsePromise, ssl, method, server, host, port, requestURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleException(Throwable t) {
        Handler<Throwable> handler;
        super.handleException(t);
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.exceptionHandler;
            if (handler == null || this.endFuture.isComplete()) {
                log.error(t);
                return;
            }
        }
        this.context.dispatch(t, handler);
        this.endPromise.tryFail(t);
    }

    @Override
    public synchronized int streamId() {
        return this.stream == null ? -1 : this.stream.id();
    }

    @Override
    public synchronized Future<NetSocket> netSocket() {
        if (this.client.getOptions().isPipelining()) {
            return Future.failedFuture("Cannot upgrade a pipe-lined request");
        }
        if (this.netSocketPromise == null) {
            this.netSocketPromise = this.context.promise();
        }
        return this.netSocketPromise.future();
    }

    @Override
    public synchronized HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.checkEnded();
        this.followRedirects = followRedirects ? this.client.getOptions().getMaxRedirects() - 1 : 0;
        return this;
    }

    @Override
    public synchronized HttpClientRequest setMaxRedirects(int maxRedirects) {
        Arguments.require(maxRedirects >= 0, "Max redirects must be >= 0");
        this.checkEnded();
        this.followRedirects = maxRedirects;
        return this;
    }

    @Override
    public synchronized HttpClientRequestImpl setChunked(boolean chunked) {
        this.checkEnded();
        if (this.stream != null) {
            throw new IllegalStateException("Cannot set chunked after data has been written on request");
        }
        if (this.client.getOptions().getProtocolVersion() != HttpVersion.HTTP_1_0) {
            this.chunked = chunked;
        }
        return this;
    }

    @Override
    public synchronized boolean isChunked() {
        return this.chunked;
    }

    @Override
    public synchronized HttpClientRequest setAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    @Override
    public synchronized String getAuthority() {
        return this.authority;
    }

    @Override
    public synchronized MultiMap headers() {
        if (this.headers == null) {
            this.headers = new VertxHttpHeaders();
        }
        return this.headers;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, String value) {
        this.checkEnded();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.checkEnded();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public synchronized HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.checkEnded();
        if (this.stream == null) {
            this.pendingMaxSize = maxSize;
        } else {
            this.stream.doSetWriteQueueMaxSize(maxSize);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean writeQueueFull() {
        this.checkEnded();
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
            if (this.stream == null) {
                return false;
            }
        }
        return this.stream.isNotWritable();
    }

    private synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public synchronized HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        if (handler != null) {
            this.checkEnded();
            this.exceptionHandler = handler;
        } else {
            this.exceptionHandler = null;
        }
        return this;
    }

    @Override
    public synchronized HttpClientRequest drainHandler(Handler<Void> handler) {
        if (handler != null) {
            this.checkEnded();
        }
        this.checkEnded();
        this.drainHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpClientRequest continueHandler(Handler<Void> handler) {
        if (handler != null) {
            this.checkEnded();
        }
        this.continueHandler = handler;
        return this;
    }

    @Override
    public Future<HttpVersion> sendHead() {
        PromiseInternal<HttpVersion> promise = this.context.promise();
        this.sendHead(promise);
        return promise.future();
    }

    @Override
    public synchronized HttpClientRequest sendHead(Handler<AsyncResult<HttpVersion>> headersHandler) {
        this.checkEnded();
        this.checkResponseHandler();
        if (this.stream != null) {
            throw new IllegalStateException("Head already written");
        }
        this.connect(headersHandler);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.checkEnded();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.checkEnded();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public synchronized HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        this.pushHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean reset(Throwable cause) {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (this.reset != null) {
                return false;
            }
            this.reset = cause;
            s = this.stream;
        }
        if (s != null) {
            s.reset(cause);
        } else {
            this.handleException(cause);
        }
        return true;
    }

    private void tryComplete() {
        this.endPromise.tryComplete();
    }

    @Override
    public synchronized HttpConnection connection() {
        return this.stream == null ? null : this.stream.connection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
            s = this.stream;
            if (s == null) {
                throw new IllegalStateException("Not yet connected");
            }
        }
        s.writeFrame(type, flags, payload.getByteBuf());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDrained() {
        Handler<Void> handler;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.drainHandler;
            if (handler == null || this.endFuture.isComplete()) {
                return;
            }
        }
        this.context.emit(handler);
    }

    private void handleNextRequest(HttpClientRequest next, Handler<AsyncResult<HttpClientResponse>> handler, long timeoutMs) {
        next.onComplete((Handler)handler);
        next.exceptionHandler((Handler)this.exceptionHandler());
        this.exceptionHandler((Handler)null);
        next.pushHandler(this.pushHandler);
        next.setMaxRedirects(this.followRedirects - 1);
        if (next.getAuthority() == null) {
            next.setAuthority(this.authority);
        }
        if (this.headers != null) {
            next.headers().addAll(this.headers);
        }
        this.endFuture.onComplete((AsyncResult<T> ar) -> {
            if (ar.succeeded()) {
                if (timeoutMs > 0L) {
                    next.setTimeout(timeoutMs);
                }
                next.end();
            } else {
                next.reset(0L);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleContinue() {
        Handler<Void> handler;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.continueHandler;
        }
        if (handler != null) {
            handler.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleResponse(Promise<HttpClientResponse> promise, HttpClientResponse resp, long timeoutMs) {
        if (this.reset != null) {
            return;
        }
        int statusCode = resp.statusCode();
        if (this.followRedirects > 0 && statusCode >= 300 && statusCode < 400) {
            Future<HttpClientRequest> next;
            ContextInternal prev = this.context.emitBegin();
            try {
                next = this.client.redirectHandler().apply(resp);
            }
            finally {
                this.context.emitEnd(prev);
            }
            if (next != null) {
                next.onComplete((AsyncResult<T> ar) -> {
                    if (ar.succeeded()) {
                        this.handleNextRequest((HttpClientRequest)ar.result(), promise, timeoutMs);
                    } else {
                        this.fail(ar.cause());
                    }
                });
                return;
            }
        }
        promise.complete(resp);
    }

    @Override
    protected String authority() {
        return this.authority != null ? this.authority : super.authority();
    }

    private synchronized void connect(Handler<AsyncResult<HttpVersion>> headersHandler) {
        if (!this.connecting) {
            SocketAddress peerAddress;
            if (this.authority != null) {
                int idx = this.authority.lastIndexOf(58);
                peerAddress = idx != -1 ? SocketAddress.inetSocketAddress(Integer.parseInt(this.authority.substring(idx + 1)), this.authority.substring(0, idx)) : SocketAddress.inetSocketAddress(80, this.authority);
            } else {
                String peerHost = this.host;
                if (peerHost.endsWith(".")) {
                    peerHost = peerHost.substring(0, peerHost.length() - 1);
                }
                peerAddress = SocketAddress.inetSocketAddress(this.port, peerHost);
            }
            this.connecting = true;
            this.client.getConnectionForRequest(this.context, peerAddress, this, this.netSocketPromise, this.ssl, this.server, ar -> {
                if (ar.succeeded()) {
                    HttpClientStream stream = (HttpClientStream)ar.result();
                    if (this.reset != null) {
                        stream.reset(this.reset);
                    } else {
                        this.connected(headersHandler, stream);
                    }
                } else {
                    this.handleException(ar.cause());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connected(Handler<AsyncResult<HttpVersion>> headersHandler, HttpClientStream stream) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.stream = stream;
            if (this.pendingMaxSize != -1) {
                stream.doSetWriteQueueMaxSize(this.pendingMaxSize);
            }
            ByteBuf pending = this.pendingChunks;
            this.pendingChunks = null;
            Handler<AsyncResult<Void>> handler = null;
            if (this.pendingHandlers != null) {
                List<Handler<AsyncResult<Void>>> handlers = this.pendingHandlers;
                this.pendingHandlers = null;
                handler = ar -> handlers.forEach(h -> h.handle(ar));
            }
            if (headersHandler != null) {
                Handler<AsyncResult<Void>> others = handler;
                handler = ar -> {
                    if (others != null) {
                        others.handle((AsyncResult<Void>)ar);
                    }
                    if (ar.succeeded()) {
                        headersHandler.handle(Future.succeededFuture(stream.version()));
                    } else {
                        headersHandler.handle(Future.failedFuture(ar.cause()));
                    }
                };
            }
            stream.writeHead(this.method, this.uri, this.headers, this.authority(), this.chunked, pending, this.ended, this.priority, handler);
            if (this.ended) {
                this.tryComplete();
            }
            this.connecting = false;
            this.stream = stream;
        }
    }

    @Override
    public Future<Void> end(String chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.end(chunk, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk), handler);
    }

    @Override
    public Future<Void> end(String chunk, String enc) {
        PromiseInternal<Void> promise = this.context.promise();
        this.end(chunk, enc, promise);
        return promise.future();
    }

    @Override
    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        this.end(Buffer.buffer(chunk, enc), handler);
    }

    @Override
    public Future<Void> end(Buffer chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(chunk.getByteBuf(), true, promise);
        return promise.future();
    }

    @Override
    public void end(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.write(chunk.getByteBuf(), true, handler);
    }

    @Override
    public Future<Void> end() {
        PromiseInternal<Void> promise = this.context.promise();
        this.end((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.write(null, true, handler);
    }

    @Override
    public Future<Void> write(Buffer chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(chunk, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void write(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        ByteBuf buf = chunk.getByteBuf();
        this.write(buf, false, handler);
    }

    @Override
    public Future<Void> write(String chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(chunk, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.write(Buffer.buffer(chunk).getByteBuf(), false, handler);
    }

    @Override
    public Future<Void> write(String chunk, String enc) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(chunk, enc, promise);
        return promise.future();
    }

    @Override
    public void write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        this.write(Buffer.buffer(chunk, enc).getByteBuf(), false, handler);
    }

    private boolean requiresContentLength() {
        return !this.chunked && (this.headers == null || !this.headers.contains(HttpHeaders.CONTENT_LENGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(ByteBuf buff, boolean end, Handler<AsyncResult<Void>> completionHandler) {
        HttpClientStream s;
        if (buff == null && !end) {
            return;
        }
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (this.ended) {
                completionHandler.handle(Future.failedFuture(new IllegalStateException("Request already complete")));
                return;
            }
            this.checkResponseHandler();
            if (end) {
                if (buff != null && this.requiresContentLength()) {
                    this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(buff.readableBytes()));
                }
            } else if (this.requiresContentLength()) {
                throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
            }
            this.ended |= end;
            if (this.stream == null) {
                if (buff != null) {
                    if (this.pendingChunks == null) {
                        this.pendingChunks = buff;
                    } else {
                        CompositeByteBuf pending;
                        if (this.pendingChunks instanceof CompositeByteBuf) {
                            pending = (CompositeByteBuf)this.pendingChunks;
                        } else {
                            pending = Unpooled.compositeBuffer();
                            pending.addComponent(true, this.pendingChunks);
                            this.pendingChunks = pending;
                        }
                        pending.addComponent(true, buff);
                    }
                }
                if (completionHandler != null) {
                    if (this.pendingHandlers == null) {
                        this.pendingHandlers = new ArrayList<Handler<AsyncResult<Void>>>();
                    }
                    this.pendingHandlers.add(completionHandler);
                }
                this.connect(null);
                return;
            }
            s = this.stream;
        }
        s.writeBuffer(buff, end, completionHandler);
        if (end) {
            this.tryComplete();
        }
    }

    private void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Request already complete");
        }
    }

    private void checkResponseHandler() {
    }

    synchronized Handler<HttpClientRequest> pushHandler() {
        return this.pushHandler;
    }

    @Override
    public synchronized HttpClientRequest setStreamPriority(StreamPriority priority) {
        if (this.stream != null) {
            this.stream.updatePriority(priority);
        } else {
            this.priority = priority;
        }
        return this;
    }

    @Override
    public synchronized StreamPriority getStreamPriority() {
        HttpClientStream s = this.stream;
        return s != null ? s.priority() : this.priority;
    }
}

