/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.ThroughputMeter;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import io.vertx.ext.dropwizard.impl.Matcher;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

class EventBusMetricsImpl
extends AbstractMetrics
implements EventBusMetrics<HandlerMetric> {
    private final HandlerMetric ignoredHandler = new HandlerMetric(null, false, true);
    private final HandlerMetric noMatchHandler = new HandlerMetric(null, true, false);
    private final ConcurrentMap<String, HandlerTimer> handlerTimers = new ConcurrentHashMap<String, HandlerTimer>();
    private final Matcher handlerMatcher;
    private final Counter handlerCount = this.counter("handlers");
    private final Counter pending = this.counter("messages", "pending");
    private final Counter pendingLocal = this.counter("messages", "pending-local");
    private final Counter pendingRemote = this.counter("messages", "pending-remote");
    private final Counter discarded = this.counter("messages", "discarded");
    private final Counter discardedLocal = this.counter("messages", "discarded-local");
    private final Counter discardedRemote = this.counter("messages", "discarded-remote");
    private final Meter bytesRead;
    private final Meter bytesWritten;
    private final ThroughputMeter receivedMessages = this.throughputMeter("messages", "received");
    private final ThroughputMeter receivedLocalMessages = this.throughputMeter("messages", "received-local");
    private final ThroughputMeter receivedRemoteMessages = this.throughputMeter("messages", "received-remote");
    private final ThroughputMeter sentMessages;
    private final ThroughputMeter sentLocalMessages;
    private final ThroughputMeter sentRemoteMessages;
    private final ThroughputMeter publishedMessages;
    private final ThroughputMeter publishedLocalMessages;
    private final ThroughputMeter publishedRemoteMessages;
    private final ThroughputMeter deliveredMessages = this.throughputMeter("messages", "delivered");
    private final ThroughputMeter deliveredLocalMessages = this.throughputMeter("messages", "delivered-local");
    private final ThroughputMeter deliveredRemoteMessages = this.throughputMeter("messages", "delivered-remote");
    private final Meter replyFailures;

    EventBusMetricsImpl(AbstractMetrics metrics, String baseName, DropwizardMetricsOptions options) {
        super(metrics.registry(), baseName);
        this.sentMessages = this.throughputMeter("messages", "sent");
        this.sentLocalMessages = this.throughputMeter("messages", "sent-local");
        this.sentRemoteMessages = this.throughputMeter("messages", "sent-remote");
        this.publishedMessages = this.throughputMeter("messages", "published");
        this.publishedLocalMessages = this.throughputMeter("messages", "published-local");
        this.publishedRemoteMessages = this.throughputMeter("messages", "published-remote");
        this.replyFailures = this.meter("messages", "reply-failures");
        this.bytesRead = this.meter("messages", "bytes-read");
        this.bytesWritten = this.meter("messages", "bytes-written");
        this.handlerMatcher = new Matcher(options.getMonitoredEventBusHandlers());
    }

    private static boolean isInternal(String address) {
        return address.startsWith("__vertx.");
    }

    public void messageWritten(String address, int size) {
        if (!EventBusMetricsImpl.isInternal(address)) {
            this.bytesWritten.mark((long)size);
        }
    }

    public void messageRead(String address, int size) {
        if (!EventBusMetricsImpl.isInternal(address)) {
            this.bytesRead.mark((long)size);
        }
    }

    public void close() {
    }

    public HandlerMetric handlerRegistered(String address, String repliedAddress) {
        if (EventBusMetricsImpl.isInternal(address)) {
            return this.ignoredHandler;
        }
        this.handlerCount.inc();
        String match = this.handlerMatcher.matches(address);
        if (match != null) {
            return new HandlerMetric(match, false, false);
        }
        return this.noMatchHandler;
    }

    public void handlerUnregistered(HandlerMetric handler) {
        if (handler.ignored) {
            return;
        }
        this.handlerCount.dec();
        if (!handler.noMatch) {
            handler.remove();
        }
    }

    public void scheduleMessage(HandlerMetric handler, boolean local) {
        if (handler.ignored) {
            return;
        }
        this.pending.inc();
        if (local) {
            this.pendingLocal.inc();
            if (!handler.noMatch) {
                ++handler.pendingLocalCount;
            }
        } else {
            this.pendingRemote.inc();
            if (!handler.noMatch) {
                ++handler.pendingRemoteCount;
            }
        }
    }

    public void discardMessage(HandlerMetric handler, boolean local, Message<?> msg) {
        if (handler.ignored) {
            return;
        }
        this.pending.dec();
        this.discarded.inc();
        if (local) {
            this.discardedLocal.inc();
            this.pendingLocal.dec();
            if (!handler.noMatch) {
                --handler.pendingLocalCount;
            }
        } else {
            this.discardedRemote.inc();
            this.pendingRemote.dec();
            if (!handler.noMatch) {
                --handler.pendingRemoteCount;
            }
        }
    }

    public void beginHandleMessage(HandlerMetric handler, boolean local) {
        if (handler.ignored) {
            return;
        }
        this.pending.dec();
        if (local) {
            this.pendingLocal.dec();
        } else {
            this.pendingRemote.dec();
        }
        if (!handler.noMatch) {
            handler.start = System.nanoTime();
            if (local) {
                --handler.pendingLocalCount;
            } else {
                --handler.pendingRemoteCount;
            }
        }
    }

    public void endHandleMessage(HandlerMetric handler, Throwable failure) {
        if (!handler.noMatch && !handler.ignored) {
            handler.timer.update(System.nanoTime() - handler.start, TimeUnit.NANOSECONDS);
        }
    }

    public void messageSent(String address, boolean publish, boolean local, boolean remote) {
        if (!EventBusMetricsImpl.isInternal(address)) {
            if (publish) {
                this.publishedMessages.mark();
                if (local) {
                    this.publishedLocalMessages.mark();
                } else {
                    this.publishedRemoteMessages.mark();
                }
            } else {
                this.sentMessages.mark();
                if (local) {
                    this.sentLocalMessages.mark();
                } else {
                    this.sentRemoteMessages.mark();
                }
            }
        }
    }

    public void messageReceived(String address, boolean publish, boolean local, int handlers) {
        if (!EventBusMetricsImpl.isInternal(address)) {
            this.receivedMessages.mark();
            if (local) {
                this.receivedLocalMessages.mark();
            } else {
                this.receivedRemoteMessages.mark();
            }
            if (handlers > 0) {
                this.deliveredMessages.mark();
                if (local) {
                    this.deliveredLocalMessages.mark();
                } else {
                    this.deliveredRemoteMessages.mark();
                }
            }
        }
    }

    public void replyFailure(String address, ReplyFailure failure) {
        this.replyFailures.mark();
        this.meter("messages", "reply-failures", failure.name()).mark();
    }

    static class HandlerTimer {
        final int refCount;
        final Timer timer;

        public HandlerTimer(int refCount, Timer timer) {
            this.refCount = refCount;
            this.timer = timer;
        }

        public HandlerTimer() {
            this(1, new Timer());
        }

        HandlerTimer inc() {
            return new HandlerTimer(this.refCount + 1, this.timer);
        }

        HandlerTimer dec() {
            return new HandlerTimer(this.refCount - 1, this.timer);
        }

        public boolean equals(Object obj) {
            HandlerTimer that = (HandlerTimer)obj;
            return this.refCount == that.refCount;
        }
    }

    public class HandlerMetric {
        final String address;
        final Timer timer;
        final String name;
        final boolean noMatch;
        final boolean ignored;
        long start;
        long pendingLocalCount;
        long pendingRemoteCount;

        public HandlerMetric(String address, boolean noMatch, boolean ignored) {
            block3: {
                HandlerTimer created;
                this.address = address;
                this.noMatch = noMatch;
                this.ignored = ignored;
                if (noMatch || ignored) {
                    this.timer = null;
                    this.name = null;
                    return;
                }
                this.name = EventBusMetricsImpl.this.nameOf("handlers", address);
                while (true) {
                    HandlerTimer existing;
                    if ((existing = (HandlerTimer)EventBusMetricsImpl.this.handlerTimers.get(address)) != null) {
                        HandlerTimer next = existing.inc();
                        if (!EventBusMetricsImpl.this.handlerTimers.replace(address, existing, next)) continue;
                        this.timer = next.timer;
                        break block3;
                    }
                    created = new HandlerTimer();
                    if (EventBusMetricsImpl.this.handlerTimers.putIfAbsent(address, created) == null) break;
                }
                EventBusMetricsImpl.this.registry.register(this.name, (Metric)created.timer);
                this.timer = created.timer;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void remove() {
            if (this.noMatch || this.ignored) return;
            while (true) {
                HandlerTimer existing = (HandlerTimer)EventBusMetricsImpl.this.handlerTimers.get(this.address);
                HandlerTimer next = existing.dec();
                if (next.refCount == 0) {
                    if (!EventBusMetricsImpl.this.handlerTimers.remove(this.address, existing)) continue;
                    EventBusMetricsImpl.this.registry.remove(this.name);
                    return;
                }
                if (EventBusMetricsImpl.this.handlerTimers.replace(this.address, existing, next)) return;
            }
        }
    }
}

