/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.vertx.java.core.impl.ConcurrentHashSet;
import org.vertx.java.platform.impl.ModuleReference;

public class ModuleClassLoader
extends URLClassLoader {
    private static ThreadLocal<Set<ModuleClassLoader>> circDepTL = new ThreadLocal();
    private static ThreadLocal<Integer> recurseDepth = new ThreadLocal();
    private final Set<ModuleReference> parents = new ConcurrentHashSet();
    private final ClassLoader platformClassLoader;
    private boolean loadResourcesFromTCCL = false;

    public ModuleClassLoader(ClassLoader platformClassLoader, URL[] classpath, boolean loadResourcesFromTCCL) {
        super(classpath);
        this.platformClassLoader = platformClassLoader;
        this.loadResourcesFromTCCL = loadResourcesFromTCCL;
    }

    public synchronized void addParent(ModuleReference parent) {
        this.parents.add(parent);
    }

    @Override
    public void close() {
        this.clearParents();
    }

    private void clearParents() {
        for (ModuleReference parent : this.parents) {
            parent.decRef();
        }
        this.parents.clear();
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.doLoadClass(name);
        if (c == null) {
            c = this.platformClassLoader.loadClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Class<?> doLoadClass(String name) {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                try {
                    this.incRecurseDepth();
                    Set<ModuleClassLoader> walked = this.getWalked();
                    walked.add(this);
                    for (ModuleReference parent : this.parents) {
                        this.checkAlreadyWalked(walked, parent);
                        c = parent.mcl.doLoadClass(name);
                        if (c == null) continue;
                        break;
                    }
                    walked.remove(this);
                }
                finally {
                    this.checkClearTLs();
                }
            }
        }
        return c;
    }

    private Set<ModuleClassLoader> getWalked() {
        Set<ModuleClassLoader> walked = circDepTL.get();
        if (walked == null) {
            walked = new HashSet<ModuleClassLoader>();
            circDepTL.set(walked);
        }
        return walked;
    }

    private void checkAlreadyWalked(Set<ModuleClassLoader> walked, ModuleReference mr) {
        if (walked.contains(mr.mcl)) {
            this.clearParents();
            throw new IllegalStateException("Circular dependency in module includes. " + mr.moduleKey);
        }
    }

    private void incRecurseDepth() {
        Integer depth = recurseDepth.get();
        recurseDepth.set(depth == null ? 1 : depth + 1);
    }

    private int decRecurseDepth() {
        Integer depth = recurseDepth.get();
        depth = depth - 1;
        recurseDepth.set(depth);
        return depth;
    }

    @Override
    public synchronized URL getResource(String name) {
        return this.doGetResource(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL doGetResource(String name, boolean considerTCCL) {
        this.incRecurseDepth();
        try {
            URL url = this.findResource(name);
            if (url == null) {
                Set<ModuleClassLoader> walked = this.getWalked();
                walked.add(this);
                for (ModuleReference parent : this.parents) {
                    this.checkAlreadyWalked(walked, parent);
                    url = parent.mcl.doGetResource(name, considerTCCL);
                    if (url == null) continue;
                    URL uRL = url;
                    return uRL;
                }
                walked.remove(this);
                if (considerTCCL && this.loadResourcesFromTCCL) {
                    walked.clear();
                    ModuleClassLoader tccl = (ModuleClassLoader)Thread.currentThread().getContextClassLoader();
                    if (tccl != this && (url = tccl.doGetResource(name, false)) != null) {
                        URL uRL = url;
                        return uRL;
                    }
                }
                url = this.platformClassLoader.getResource(name);
            }
            URL uRL = url;
            return uRL;
        }
        finally {
            this.checkClearTLs();
        }
    }

    private void checkClearTLs() {
        if (this.decRecurseDepth() == 0) {
            circDepTL.remove();
            recurseDepth.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Enumeration<URL> getResources(String name) throws IOException {
        final ArrayList<URL> totURLs = new ArrayList<URL>();
        this.addURLs(totURLs, this.findResources(name));
        try {
            this.incRecurseDepth();
            Set<ModuleClassLoader> walked = this.getWalked();
            walked.add(this);
            for (ModuleReference parent : this.parents) {
                this.checkAlreadyWalked(walked, parent);
                Enumeration<URL> urls = parent.mcl.getResources(name);
                this.addURLs(totURLs, urls);
            }
            walked.remove(this);
        }
        finally {
            this.checkClearTLs();
        }
        this.addURLs(totURLs, this.platformClassLoader.getResources(name));
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = totURLs.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void addURLs(List<URL> urls, Enumeration<URL> toAdd) {
        if (toAdd != null) {
            while (toAdd.hasMoreElements()) {
                urls.add(toAdd.nextElement());
            }
        }
    }
}

