/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VertxException;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.json.DecodeException;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.PlatformLocator;
import org.vertx.java.platform.PlatformManager;
import org.vertx.java.platform.impl.Args;
import org.vertx.java.platform.impl.resolver.HttpResolution;

public class Starter {
    private static final Logger log = LoggerFactory.getLogger(Starter.class);
    private static final String CP_SEPARATOR = System.getProperty("path.separator");
    private final CountDownLatch stopLatch = new CountDownLatch(1);

    public static void main(String[] args) {
        HttpResolution.suppressDownloadCounter = false;
        System.setProperty("vertx.loadWithPlatformCL", "false");
        new Starter(args);
    }

    private Starter(String[] sargs) {
        if (sargs.length < 1) {
            Starter.displaySyntax();
        } else {
            String command = sargs[0].toLowerCase();
            Args args = new Args(sargs);
            if ("version".equals(command)) {
                log.info((Object)this.getVersion());
            } else if (sargs.length < 2) {
                Starter.displaySyntax();
            } else {
                String operand = sargs[1];
                switch (command) {
                    case "run": {
                        this.runVerticle(false, false, operand, args);
                        break;
                    }
                    case "runmod": {
                        this.runVerticle(false, true, operand, args);
                        break;
                    }
                    case "runzip": {
                        this.runVerticle(true, true, operand, args);
                        break;
                    }
                    case "install": {
                        this.installModule(operand);
                        break;
                    }
                    case "uninstall": {
                        this.uninstallModule(operand);
                        break;
                    }
                    case "pulldeps": {
                        this.pullDependencies(operand);
                        break;
                    }
                    default: {
                        Starter.displaySyntax();
                    }
                }
            }
        }
    }

    private static <T> AsyncResultHandler<T> createLoggingHandler(final String successMessage, final Handler<AsyncResult<T>> doneHandler) {
        return new AsyncResultHandler<T>(){

            public void handle(AsyncResult<T> res) {
                if (res.failed()) {
                    Throwable cause = res.cause();
                    if (cause instanceof VertxException) {
                        VertxException ve = (VertxException)cause;
                        log.error((Object)ve.getMessage());
                        if (ve.getCause() != null) {
                            log.error((Object)ve.getCause());
                        }
                    } else {
                        log.error((Object)cause);
                    }
                } else {
                    log.trace((Object)successMessage);
                }
                if (doneHandler != null) {
                    doneHandler.handle(res);
                }
            }
        };
    }

    private Handler<AsyncResult<Void>> unblockHandler() {
        return new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> res) {
                Starter.this.unblock();
            }
        };
    }

    private void pullDependencies(String modName) {
        log.info((Object)("Attempting to pull in dependencies for module " + modName));
        this.createPM().pullInDependencies(modName, (Handler<AsyncResult<Void>>)Starter.createLoggingHandler("Successfully pulled in dependencies", this.unblockHandler()));
        this.block();
    }

    private void installModule(String modName) {
        log.info((Object)("Attempting to install module " + modName));
        this.createPM().installModule(modName, (Handler<AsyncResult<Void>>)Starter.createLoggingHandler("Successfully installed module", this.unblockHandler()));
        this.block();
    }

    private void uninstallModule(String modName) {
        log.info((Object)("Attempting to uninstall module " + modName));
        this.createPM().uninstallModule(modName, (Handler<AsyncResult<Void>>)Starter.createLoggingHandler("Successfully uninstalled module", this.unblockHandler()));
        this.block();
    }

    private PlatformManager createPM() {
        PlatformManager pm = PlatformLocator.factory.createPlatformManager();
        this.registerExitHandler(pm);
        return pm;
    }

    private PlatformManager createPM(int port, String host) {
        PlatformManager pm = PlatformLocator.factory.createPlatformManager(port, host);
        this.registerExitHandler(pm);
        return pm;
    }

    private void registerExitHandler(PlatformManager mgr) {
        mgr.registerExitHandler((Handler<Void>)new VoidHandler(){

            public void handle() {
                Starter.this.unblock();
            }
        });
    }

    private void runVerticle(boolean zip, boolean module, String main, Args args) {
        String cp;
        boolean hasClasspath;
        JsonObject conf;
        int instances;
        PlatformManager mgr;
        block44: {
            String configFile;
            block43: {
                boolean clustered;
                boolean bl = clustered = args.map.get("-cluster") != null;
                if (clustered) {
                    String clusterHost;
                    log.info((Object)"Starting clustering...");
                    int clusterPort = args.getInt("-cluster-port");
                    if (clusterPort == -1) {
                        clusterPort = 0;
                    }
                    if ((clusterHost = args.map.get("-cluster-host")) == null) {
                        clusterHost = Starter.getDefaultAddress();
                        if (clusterHost == null) {
                            log.error((Object)"Unable to find a default network interface for clustering. Please specify one using -cluster-host");
                            return;
                        }
                        log.info((Object)("No cluster-host specified so using address " + clusterHost));
                    }
                    mgr = this.createPM(clusterPort, clusterHost);
                } else {
                    mgr = this.createPM();
                }
                String sinstances = args.map.get("-instances");
                if (sinstances != null) {
                    try {
                        instances = Integer.parseInt(sinstances);
                        if (instances != -1 && instances < 1) {
                            log.error((Object)"Invalid number of instances");
                            Starter.displaySyntax();
                            return;
                        }
                        break block43;
                    }
                    catch (NumberFormatException e) {
                        Starter.displaySyntax();
                        return;
                    }
                }
                instances = 1;
            }
            if ((configFile = args.map.get("-conf")) != null) {
                try (Scanner scanner = new Scanner(new File(configFile)).useDelimiter("\\A");){
                    String sconf = scanner.next();
                    try {
                        conf = new JsonObject(sconf);
                        break block44;
                    }
                    catch (DecodeException e) {
                        log.error((Object)"Configuration file does not contain a valid JSON object");
                        if (scanner != null) {
                            if (var12_15 != null) {
                                try {
                                    scanner.close();
                                }
                                catch (Throwable x2) {
                                    var12_15.addSuppressed(x2);
                                }
                            } else {
                                scanner.close();
                            }
                        }
                        return;
                    }
                }
                catch (FileNotFoundException e) {
                    log.error((Object)("Config file " + configFile + " does not exist"));
                    return;
                }
            }
            conf = null;
        }
        boolean bl = hasClasspath = (cp = args.map.get("-cp")) != null;
        if (cp == null) {
            cp = ".";
        }
        String[] parts = cp.contains(CP_SEPARATOR) ? cp.split(CP_SEPARATOR) : new String[]{cp};
        int index = 0;
        URL[] classpath = new URL[parts.length];
        for (String part : parts) {
            try {
                URL url = new File(part).toURI().toURL();
                classpath[index++] = url;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid path " + part + " in cp " + cp);
            }
        }
        Handler<AsyncResult<String>> doneHandler = new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> res) {
                if (res.failed()) {
                    Starter.this.unblock();
                }
            }
        };
        if (zip) {
            mgr.deployModuleFromZip(main, conf, instances, (Handler<AsyncResult<String>>)Starter.createLoggingHandler("Successfully deployed module from zip", doneHandler));
        } else if (module) {
            if (hasClasspath) {
                mgr.deployModuleFromClasspath(main, conf, instances, classpath, (Handler<AsyncResult<String>>)Starter.createLoggingHandler("Successfully deployed module", doneHandler));
            } else {
                mgr.deployModule(main, conf, instances, (Handler<AsyncResult<String>>)Starter.createLoggingHandler("Successfully deployed module", doneHandler));
            }
        } else {
            boolean worker = args.map.get("-worker") != null;
            String includes = args.map.get("-includes");
            if (worker) {
                mgr.deployWorkerVerticle(false, main, conf, classpath, instances, includes, (Handler<AsyncResult<String>>)Starter.createLoggingHandler("Successfully deployed worker verticle", doneHandler));
            } else {
                mgr.deployVerticle(main, conf, classpath, instances, includes, (Handler<AsyncResult<String>>)Starter.createLoggingHandler("Successfully deployed verticle", doneHandler));
            }
        }
        Starter.addShutdownHook(mgr);
        this.block();
    }

    private void block() {
        while (true) {
            try {
                this.stopLatch.await();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void unblock() {
        this.stopLatch.countDown();
    }

    private static void addShutdownHook(final PlatformManager mgr) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                final CountDownLatch latch = new CountDownLatch(1);
                mgr.undeployAll(new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> res) {
                        latch.countDown();
                    }
                });
                while (true) {
                    try {
                        if (latch.await(30L, TimeUnit.SECONDS)) break;
                        log.error((Object)"Timed out waiting to undeploy");
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        });
    }

    private static String getDefaultAddress() {
        Enumeration<NetworkInterface> nets;
        try {
            nets = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (nets.hasMoreElements()) {
            NetworkInterface netinf = nets.nextElement();
            Enumeration<InetAddress> addresses = netinf.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isAnyLocalAddress() || address.isMulticastAddress() || address instanceof Inet6Address) continue;
                return address.getHostAddress();
            }
        }
        return null;
    }

    public final String getVersion() {
        Manifest manifest;
        String className = this.getClass().getSimpleName() + ".class";
        String classPath = this.getClass().getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return "<unknown> (not a jar)";
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
        try (InputStream is = new URL(manifestPath).openStream();){
            manifest = new Manifest(is);
        }
        catch (IOException ex) {
            return "<unknown> (" + ex.getMessage() + ')';
        }
        Attributes attr = manifest.getMainAttributes();
        return attr.getValue("Vertx-Version");
    }

    private static void displaySyntax() {
        String usage = "    vertx run <main> [-options]                                                \n        runs a verticle called <main> in its own instance of vert.x.           \n        <main> can be a JavaScript script, a Ruby script, A Groovy script,     \n        a Java class, a Java source file, or a Python Script.\n\n    valid options are:\n        -conf <config_file>    Specifies configuration that should be provided \n                               to the verticle. <config_file> should reference \n                               a text file containing a valid JSON object      \n                               which represents the configuration.             \n        -cp <path>             specifies the path on which to search for       \n                               <main> and any referenced resources.            \n                               Defaults to '.' (current directory).            \n        -instances <instances> specifies how many instances of the verticle    \n                               will be deployed. Defaults to 1                 \n        -worker                if specified then the verticle is a worker      \n                               verticle.                                       \n        -includes <mod_list>   optional comma separated list of modules        \n                               which will be added to the classpath of         \n                               the verticle.                                   \n        -cluster               if specified then the vert.x instance will form \n                               a cluster with any other vert.x instances on    \n                               the network.                                    \n        -cluster-port          port to use for cluster communication.          \n                               Default is 0 which means chose a spare          \n                               random port.                                    \n        -cluster-host          host to bind to for cluster communication.      \n                               If this is not specified vert.x will attempt    \n                               to choose one from the available interfaces.  \n\n    vertx runmod <modname> [-options]                                          \n        runs a module called <modname> in its own instance of vert.x.          \n        If the module is not already installed, Vert.x will attempt to install \n        it from a repository before running it.                            \n\n    valid options are:                                                         \n        -conf <config_file>    Specifies configuration that should be provided \n                               to the module. <config_file> should reference   \n                               a text file containing a valid JSON object      \n                               which represents the configuration.             \n        -instances <instances> specifies how many instances of the verticle    \n                               will be deployed. Defaults to 1                 \n        -cluster               if specified then the vert.x instance will form \n                               a cluster with any other vert.x instances on    \n                               the network.                                    \n        -cluster-port          port to use for cluster communication.          \n                               Default is 0 which means chose a spare          \n                               random port.                                    \n        -cluster-host          host to bind to for cluster communication.      \n                               If this is not specified vert.x will attempt    \n                               to choose one from the available interfaces.    \n        -cp <path>             if specified Vert.x will attempt to find the    \n                               module on the classpath represented by this     \n                               path and not in the modules directory         \n\n    vertx runzip <zipfilename> [-options]                                      \n        installs then deploys a module which is contained in the zip specified \n        by <zipfilename>. The module will be installed with a name given by    \n        <zipfilename> without the .zip extension. If a module with that name   \n        is already installed this will do nothing.                             \n        The options accepted by this command are exactly the same as those     \n        accepted by vertx runmod                                             \n\n    vertx install <modname> [-options]                                         \n        attempts to install a module from a remote repository.                 \n        Module will be installed into a local 'mods' directory or, if the      \n        module is marked as a system module, the sys-mods directory in the     \n        Vert.x installation unless the                                         \n        environment variable VERTX_MODS specifies a different location.      \n\n    vertx uninstall <modname>                                                  \n        attempts to uninstall a module from a remote repository.               \n        Module will be uninstalled from the local 'mods' directory unless the  \n        environment variable VERTX_MODS specifies a different location.      \n\n    vertx pulldeps <modname>                                                   \n        Pulls in the tree of dependencies of the module and puts them in the   \n        nested module directory (mods) of the module. This allows the module   \n        to be a completely self contained unit containing all the modules it   \n        needs to run.                                                          \n        Vert.x will consult the 'includes' and 'deploys' fields to determine   \n        which modules to pull in.                                            \n\n    vertx version                                                              \n        displays the version";
        log.info((Object)usage);
    }
}

