/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.resolver;

import java.net.URI;
import java.net.URISyntaxException;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.impl.ModuleIdentifier;
import org.vertx.java.platform.impl.resolver.HttpResolution;

public class BintrayResolution
extends HttpResolution {
    private static final Logger log = LoggerFactory.getLogger(BintrayResolution.class);
    private final String uri;

    public BintrayResolution(Vertx vertx, String repoHost, int repoPort, ModuleIdentifier moduleID, final String filename, String contentRoot) {
        super(vertx, repoHost, repoPort, moduleID, filename);
        this.addHandler(200, new Handler<HttpClientResponse>(){

            public void handle(HttpClientResponse resp) {
                BintrayResolution.this.downloadToFile(filename, resp);
            }
        });
        this.addHandler(302, new Handler<HttpClientResponse>(){

            public void handle(HttpClientResponse resp) {
                BintrayResolution.this.handle302(resp);
            }
        });
        String user = moduleID.getOwner();
        String repo = "vertx-mods";
        String modName = moduleID.getName();
        String version = moduleID.getVersion();
        StringBuilder sb = new StringBuilder(contentRoot);
        sb.append('/');
        sb.append(user).append('/').append(repo).append('/').append(modName).append('/').append(modName).append('-').append(version).append(".zip");
        this.uri = sb.toString();
    }

    @Override
    protected void getModule() {
        this.createClient(this.repoHost, this.repoPort);
        this.makeRequest(this.repoHost, this.repoPort, this.uri);
    }

    protected void handle302(HttpClientResponse resp) {
        String location = resp.headers().get("location");
        if (location == null) {
            log.error((Object)"HTTP redirect with no location header");
        } else {
            try {
                URI redirectURI = new URI(location);
                this.client.close();
                this.client = null;
                int redirectPort = redirectURI.getPort();
                if (redirectPort == -1) {
                    redirectPort = 80;
                }
                this.createClient(redirectURI.getHost(), redirectPort);
                this.makeRequest(redirectURI.getHost(), redirectPort, redirectURI.getPath());
            }
            catch (URISyntaxException e) {
                log.error((Object)("Invalid redirect URI: " + location));
            }
        }
    }
}

