/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core;

import io.netty.channel.EventLoopGroup;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Context;
import io.vertx.reactivex.core.Promise;
import io.vertx.reactivex.core.TimeoutStream;
import io.vertx.reactivex.core.WorkerExecutor;
import io.vertx.reactivex.core.datagram.DatagramSocket;
import io.vertx.reactivex.core.dns.DnsClient;
import io.vertx.reactivex.core.eventbus.EventBus;
import io.vertx.reactivex.core.file.FileSystem;
import io.vertx.reactivex.core.http.HttpClient;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.NetClient;
import io.vertx.reactivex.core.net.NetServer;
import io.vertx.reactivex.core.shareddata.SharedData;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@RxGen(value=io.vertx.core.Vertx.class)
public class Vertx
implements Measured {
    public static final TypeArg<Vertx> __TYPE_ARG = new TypeArg(obj -> new Vertx((io.vertx.core.Vertx)obj), Vertx::getDelegate);
    private final io.vertx.core.Vertx delegate;
    private FileSystem cached_0;
    private EventBus cached_1;
    private SharedData cached_2;
    private Boolean cached_3;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertx that = (Vertx)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Vertx(io.vertx.core.Vertx delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.Vertx getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public static Vertx vertx() {
        Vertx ret = Vertx.newInstance(io.vertx.core.Vertx.vertx());
        return ret;
    }

    public static Vertx vertx(VertxOptions options) {
        Vertx ret = Vertx.newInstance(io.vertx.core.Vertx.vertx((VertxOptions)options));
        return ret;
    }

    public static void clusteredVertx(VertxOptions options, final Handler<AsyncResult<Vertx>> resultHandler) {
        io.vertx.core.Vertx.clusteredVertx((VertxOptions)options, (Handler)new Handler<AsyncResult<io.vertx.core.Vertx>>(){

            public void handle(AsyncResult<io.vertx.core.Vertx> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)Vertx.newInstance((io.vertx.core.Vertx)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static void clusteredVertx(VertxOptions options) {
        Vertx.clusteredVertx(options, (Handler<AsyncResult<Vertx>>)((Handler)ar -> {}));
    }

    public static Single<Vertx> rxClusteredVertx(VertxOptions options) {
        return AsyncResultSingle.toSingle($handler -> Vertx.clusteredVertx(options, (Handler<AsyncResult<Vertx>>)$handler));
    }

    public static Context currentContext() {
        Context ret = Context.newInstance(io.vertx.core.Vertx.currentContext());
        return ret;
    }

    public Context getOrCreateContext() {
        Context ret = Context.newInstance(this.delegate.getOrCreateContext());
        return ret;
    }

    public NetServer createNetServer(NetServerOptions options) {
        NetServer ret = NetServer.newInstance(this.delegate.createNetServer(options));
        return ret;
    }

    public NetServer createNetServer() {
        NetServer ret = NetServer.newInstance(this.delegate.createNetServer());
        return ret;
    }

    public NetClient createNetClient(NetClientOptions options) {
        NetClient ret = NetClient.newInstance(this.delegate.createNetClient(options));
        return ret;
    }

    public NetClient createNetClient() {
        NetClient ret = NetClient.newInstance(this.delegate.createNetClient());
        return ret;
    }

    public HttpServer createHttpServer(HttpServerOptions options) {
        HttpServer ret = HttpServer.newInstance(this.delegate.createHttpServer(options));
        return ret;
    }

    public HttpServer createHttpServer() {
        HttpServer ret = HttpServer.newInstance(this.delegate.createHttpServer());
        return ret;
    }

    public HttpClient createHttpClient(HttpClientOptions options) {
        HttpClient ret = HttpClient.newInstance(this.delegate.createHttpClient(options));
        return ret;
    }

    public HttpClient createHttpClient() {
        HttpClient ret = HttpClient.newInstance(this.delegate.createHttpClient());
        return ret;
    }

    public DatagramSocket createDatagramSocket(DatagramSocketOptions options) {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.createDatagramSocket(options));
        return ret;
    }

    public DatagramSocket createDatagramSocket() {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.createDatagramSocket());
        return ret;
    }

    public FileSystem fileSystem() {
        FileSystem ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = FileSystem.newInstance(this.delegate.fileSystem());
        return ret;
    }

    public EventBus eventBus() {
        EventBus ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = EventBus.newInstance(this.delegate.eventBus());
        return ret;
    }

    public DnsClient createDnsClient(int port, String host) {
        DnsClient ret = DnsClient.newInstance(this.delegate.createDnsClient(port, host));
        return ret;
    }

    public DnsClient createDnsClient() {
        DnsClient ret = DnsClient.newInstance(this.delegate.createDnsClient());
        return ret;
    }

    public DnsClient createDnsClient(DnsClientOptions options) {
        DnsClient ret = DnsClient.newInstance(this.delegate.createDnsClient(options));
        return ret;
    }

    public SharedData sharedData() {
        SharedData ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = SharedData.newInstance(this.delegate.sharedData());
        return ret;
    }

    public long setTimer(long delay, Handler<Long> handler) {
        long ret = this.delegate.setTimer(delay, handler);
        return ret;
    }

    public TimeoutStream timerStream(long delay) {
        TimeoutStream ret = TimeoutStream.newInstance(this.delegate.timerStream(delay));
        return ret;
    }

    public long setPeriodic(long delay, Handler<Long> handler) {
        long ret = this.delegate.setPeriodic(delay, handler);
        return ret;
    }

    public TimeoutStream periodicStream(long delay) {
        TimeoutStream ret = TimeoutStream.newInstance(this.delegate.periodicStream(delay));
        return ret;
    }

    public boolean cancelTimer(long id) {
        boolean ret = this.delegate.cancelTimer(id);
        return ret;
    }

    public void runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(action);
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) {
        this.delegate.deployVerticle(name, completionHandler);
    }

    public void deployVerticle(String name) {
        this.deployVerticle(name, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxDeployVerticle(String name) {
        return AsyncResultSingle.toSingle($handler -> this.deployVerticle(name, (Handler<AsyncResult<String>>)$handler));
    }

    public void deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        this.delegate.deployVerticle(name, options, completionHandler);
    }

    public void deployVerticle(String name, DeploymentOptions options) {
        this.deployVerticle(name, options, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxDeployVerticle(String name, DeploymentOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.deployVerticle(name, options, (Handler<AsyncResult<String>>)$handler));
    }

    public void undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.undeploy(deploymentID, completionHandler);
    }

    public void undeploy(String deploymentID) {
        this.undeploy(deploymentID, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxUndeploy(String deploymentID) {
        return AsyncResultCompletable.toCompletable($handler -> this.undeploy(deploymentID, (Handler<AsyncResult<Void>>)$handler));
    }

    public Set<String> deploymentIDs() {
        Set ret = this.delegate.deploymentIDs();
        return ret;
    }

    public boolean isClustered() {
        boolean ret = this.delegate.isClustered();
        return ret;
    }

    public <T> void executeBlocking(final Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>(){

            public void handle(io.vertx.core.Promise<T> event) {
                blockingCodeHandler.handle(Promise.newInstance(event, TypeArg.unknown()));
            }
        }, ordered, resultHandler);
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        this.executeBlocking(blockingCodeHandler, ordered, ar -> {});
    }

    public <T> Maybe<T> rxExecuteBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        return AsyncResultMaybe.toMaybe($handler -> this.executeBlocking(blockingCodeHandler, ordered, (Handler)$handler));
    }

    public <T> void executeBlocking(final Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>(){

            public void handle(io.vertx.core.Promise<T> event) {
                blockingCodeHandler.handle(Promise.newInstance(event, TypeArg.unknown()));
            }
        }, resultHandler);
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        this.executeBlocking(blockingCodeHandler, ar -> {});
    }

    public <T> Maybe<T> rxExecuteBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return AsyncResultMaybe.toMaybe($handler -> this.executeBlocking(blockingCodeHandler, (Handler)$handler));
    }

    public WorkerExecutor createSharedWorkerExecutor(String name) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name));
        return ret;
    }

    public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name, poolSize));
        return ret;
    }

    public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime));
        return ret;
    }

    public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime, maxExecuteTimeUnit));
        return ret;
    }

    public boolean isNativeTransportEnabled() {
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        boolean ret = this.delegate.isNativeTransportEnabled();
        this.cached_3 = ret;
        return ret;
    }

    public Vertx exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public void deployVerticle(Verticle verticle, Handler<AsyncResult<String>> completionHandler) {
        this.delegate.deployVerticle(verticle, completionHandler);
    }

    public void deployVerticle(Verticle verticle) {
        this.deployVerticle(verticle, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxDeployVerticle(Verticle verticle) {
        return AsyncResultSingle.toSingle($handler -> this.deployVerticle(verticle, (Handler<AsyncResult<String>>)$handler));
    }

    public void deployVerticle(Verticle verticle, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        this.delegate.deployVerticle(verticle, options, completionHandler);
    }

    public void deployVerticle(Verticle verticle, DeploymentOptions options) {
        this.deployVerticle(verticle, options, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxDeployVerticle(Verticle verticle, DeploymentOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.deployVerticle(verticle, options, (Handler<AsyncResult<String>>)$handler));
    }

    public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        this.delegate.deployVerticle(verticleSupplier, options, completionHandler);
    }

    public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options) {
        this.deployVerticle(verticleSupplier, options, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxDeployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.deployVerticle(verticleSupplier, options, (Handler<AsyncResult<String>>)$handler));
    }

    public void registerVerticleFactory(VerticleFactory factory) {
        this.delegate.registerVerticleFactory(factory);
    }

    public void unregisterVerticleFactory(VerticleFactory factory) {
        this.delegate.unregisterVerticleFactory(factory);
    }

    public Set<VerticleFactory> verticleFactories() {
        Set ret = this.delegate.verticleFactories();
        return ret;
    }

    public EventLoopGroup nettyEventLoopGroup() {
        EventLoopGroup ret = this.delegate.nettyEventLoopGroup();
        return ret;
    }

    public static Vertx newInstance(io.vertx.core.Vertx arg) {
        return arg != null ? new Vertx(arg) : null;
    }
}

