/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.net;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.NetSocket;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.net.NetClient.class)
public class NetClient
implements Measured {
    public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg(obj -> new NetClient((io.vertx.core.net.NetClient)obj), NetClient::getDelegate);
    private final io.vertx.core.net.NetClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetClient that = (NetClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetClient(io.vertx.core.net.NetClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.net.NetClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public NetClient connect(int port, String host, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public NetClient connect(int port, String host) {
        return this.connect(port, host, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(int port, String host) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host, (Handler<AsyncResult<NetSocket>>)$handler));
    }

    public NetClient connect(int port, String host, String serverName, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(port, host, serverName, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public NetClient connect(int port, String host, String serverName) {
        return this.connect(port, host, serverName, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(int port, String host, String serverName) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host, serverName, (Handler<AsyncResult<NetSocket>>)$handler));
    }

    public NetClient connect(SocketAddress remoteAddress, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(remoteAddress.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public NetClient connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress) {
        return AsyncResultSingle.toSingle($handler -> this.connect(remoteAddress, (Handler<AsyncResult<NetSocket>>)$handler));
    }

    public NetClient connect(SocketAddress remoteAddress, String serverName, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(remoteAddress.getDelegate(), serverName, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public NetClient connect(SocketAddress remoteAddress, String serverName) {
        return this.connect(remoteAddress, serverName, (Handler<AsyncResult<NetSocket>>)((Handler)ar -> {}));
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress, String serverName) {
        return AsyncResultSingle.toSingle($handler -> this.connect(remoteAddress, serverName, (Handler<AsyncResult<NetSocket>>)$handler));
    }

    public void close() {
        this.delegate.close();
    }

    public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
        return arg != null ? new NetClient(arg) : null;
    }
}

