/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.utils;

import java.util.Objects;

public class ClassLoaderUtils {
    private static final ClassLoader CURRENT = ClassLoaderUtils.class.getClassLoader();

    public static <T> Class<T> load(String className, ClassLoader classLoader) {
        Objects.requireNonNull(className);
        Class<T> loaded = ClassLoaderUtils.tryToLoad(className, CURRENT);
        if (loaded == null && classLoader != null) {
            return ClassLoaderUtils.tryToLoad(className, classLoader);
        }
        if (loaded == null && Thread.currentThread().getContextClassLoader() != null) {
            return ClassLoaderUtils.tryToLoad(className, Thread.currentThread().getContextClassLoader());
        }
        return loaded;
    }

    private static <T> Class<T> tryToLoad(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

