/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.core.Vertx;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;

public abstract class AbstractServiceReference<T>
implements ServiceReference {
    private final ServiceDiscovery discovery;
    protected T service;
    private final Record record;
    protected final Vertx vertx;

    public AbstractServiceReference(Vertx vertx, ServiceDiscovery discovery, Record record) {
        this.record = record;
        this.discovery = discovery;
        this.vertx = vertx;
    }

    public synchronized <X> X cached() {
        return (X)this.service;
    }

    public synchronized <X> X get() {
        if (this.service == null) {
            this.service = this.retrieve();
        }
        return this.cached();
    }

    protected abstract T retrieve();

    protected void close() {
    }

    @Override
    public Record record() {
        return this.record;
    }

    @Override
    public synchronized void release() {
        ((DiscoveryImpl)this.discovery).unbind(this);
        if (this.service != null) {
            this.close();
            this.service = null;
        }
    }
}

