/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.spi.ServiceType;
import java.util.Objects;

public interface DataSource
extends ServiceType {
    public static final String DS_TYPE = "datasource.type";
    public static final String TYPE = "datasource";

    public static void getDataSourceMetadata(ServiceDiscovery discovery, JsonObject filter, Handler<AsyncResult<JsonObject>> resultHandler) {
        discovery.getRecord(filter, (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.failed() || ar.result() == null) {
                resultHandler.handle((Object)Future.failedFuture((String)"No matching record"));
            } else {
                Record record = (Record)ar.result();
                JsonObject result = record.getMetadata().copy();
                result.mergeIn(record.getLocation());
                resultHandler.handle((Object)Future.succeededFuture((Object)result));
            }
        }));
    }

    public static Record createRecord(String name, String type, JsonObject location, JsonObject metadata) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        Objects.requireNonNull(location);
        Record record = new Record().setName(name).setType(TYPE).setLocation(location);
        if (metadata != null) {
            record.setMetadata(metadata);
        }
        record.setMetadata(new JsonObject().put(DS_TYPE, type));
        return record;
    }
}

