/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.FormLoginHandler;

public class FormLoginHandlerImpl
implements FormLoginHandler {
    private static final Logger log = LoggerFactory.getLogger(FormLoginHandlerImpl.class);
    private final AuthProvider authProvider;
    private final String usernameParam;
    private final String passwordParam;
    private final String returnURLParam;

    public FormLoginHandlerImpl(AuthProvider authProvider, String usernameParam, String passwordParam, String returnURLParam) {
        this.authProvider = authProvider;
        this.usernameParam = usernameParam;
        this.passwordParam = passwordParam;
        this.returnURLParam = returnURLParam;
    }

    public void handle(RoutingContext context) {
        HttpServerRequest req = context.request();
        if (req.method() != HttpMethod.POST) {
            context.fail(405);
        } else {
            if (!req.isExpectMultipart()) {
                throw new IllegalStateException("Form body not parsed - do you forget to include a BodyHandler?");
            }
            MultiMap params = req.formAttributes();
            String username = params.get(this.usernameParam);
            String password = params.get(this.passwordParam);
            if (username == null || password == null) {
                log.warn((Object)"No username or password provided in form - did you forget to include a BodyHandler?");
                context.fail(400);
            } else {
                Session session = context.session();
                if (session == null) {
                    context.fail(new NullPointerException("No session - did you forget to include a SessionHandler?"));
                } else {
                    JsonObject authInfo = new JsonObject().put("username", username).put("password", password);
                    this.authProvider.authenticate(authInfo, res -> {
                        if (res.succeeded()) {
                            User user = (User)res.result();
                            context.setUser(user);
                            String returnURL = (String)session.remove(this.returnURLParam);
                            if (returnURL == null) {
                                context.fail(new IllegalStateException("Logged in OK, but no return URL"));
                            } else {
                                req.response().putHeader("location", returnURL).setStatusCode(302).end();
                            }
                        } else {
                            context.fail(403);
                        }
                    });
                }
            }
        }
    }
}

