/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RoutingContextImpl;
import io.vertx.ext.web.impl.RoutingContextWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;

public class RouterImpl
implements Router {
    private static final Logger log = LoggerFactory.getLogger(RouterImpl.class);
    private final Vertx vertx;
    private final Set<RouteImpl> routes = new ConcurrentSkipListSet<RouteImpl>((o1, o2) -> Integer.compare(o1.order(), o2.order()));
    private final AtomicInteger orderSequence = new AtomicInteger();
    private Handler<Throwable> exceptionHandler;

    public RouterImpl(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public void accept(HttpServerRequest request) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Router: " + System.identityHashCode(this) + " accepting request " + request.method() + " " + request.absoluteURI()));
        }
        new RoutingContextImpl(null, this, request, this.routes.iterator()).next();
    }

    @Override
    public Route route() {
        return new RouteImpl(this, this.orderSequence.getAndIncrement());
    }

    @Override
    public Route route(HttpMethod method, String path) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), method, path);
    }

    @Override
    public Route route(String path) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), path);
    }

    @Override
    public Route routeWithRegex(HttpMethod method, String regex) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), method, regex, true);
    }

    @Override
    public Route routeWithRegex(String regex) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), regex, true);
    }

    @Override
    public Route get() {
        return this.route().method(HttpMethod.GET);
    }

    @Override
    public Route get(String path) {
        return this.route(HttpMethod.GET, path);
    }

    @Override
    public Route getWithRegex(String path) {
        return this.route().method(HttpMethod.GET).pathRegex(path);
    }

    @Override
    public Route head() {
        return this.route().method(HttpMethod.HEAD);
    }

    @Override
    public Route head(String path) {
        return this.route(HttpMethod.HEAD, path);
    }

    @Override
    public Route headWithRegex(String path) {
        return this.route().method(HttpMethod.HEAD).pathRegex(path);
    }

    @Override
    public Route options() {
        return this.route().method(HttpMethod.OPTIONS);
    }

    @Override
    public Route options(String path) {
        return this.route(HttpMethod.OPTIONS, path);
    }

    @Override
    public Route optionsWithRegex(String path) {
        return this.route().method(HttpMethod.OPTIONS).pathRegex(path);
    }

    @Override
    public Route put() {
        return this.route().method(HttpMethod.PUT);
    }

    @Override
    public Route put(String path) {
        return this.route(HttpMethod.PUT, path);
    }

    @Override
    public Route putWithRegex(String path) {
        return this.route().method(HttpMethod.PUT).pathRegex(path);
    }

    @Override
    public Route post() {
        return this.route().method(HttpMethod.POST);
    }

    @Override
    public Route post(String path) {
        return this.route(HttpMethod.POST, path);
    }

    @Override
    public Route postWithRegex(String path) {
        return this.route().method(HttpMethod.POST).pathRegex(path);
    }

    @Override
    public Route delete() {
        return this.route().method(HttpMethod.DELETE);
    }

    @Override
    public Route delete(String path) {
        return this.route(HttpMethod.DELETE, path);
    }

    @Override
    public Route deleteWithRegex(String path) {
        return this.route().method(HttpMethod.DELETE).pathRegex(path);
    }

    @Override
    public List<Route> getRoutes() {
        return new ArrayList<Route>(this.routes);
    }

    @Override
    public Router clear() {
        this.routes.clear();
        return this;
    }

    @Override
    public void handleContext(RoutingContext ctx) {
        new RoutingContextWrapper(this.getAndCheckRoutePath(ctx), ctx.request(), this.routes.iterator(), ctx).next();
    }

    @Override
    public void handleFailure(RoutingContext ctx) {
        new RoutingContextWrapper(this.getAndCheckRoutePath(ctx), ctx.request(), this.routes.iterator(), ctx).next();
    }

    @Override
    public Router mountSubRouter(String mountPoint, Router subRouter) {
        if (mountPoint.endsWith("*")) {
            throw new IllegalArgumentException("Don't include * when mounting subrouter");
        }
        if (mountPoint.contains(":")) {
            throw new IllegalArgumentException("Can't use patterns in subrouter mounts");
        }
        this.route(mountPoint + "*").handler((Handler<RoutingContext>)((Handler)subRouter::handleContext)).failureHandler((Handler<RoutingContext>)((Handler)subRouter::handleFailure));
        return this;
    }

    @Override
    public synchronized Router exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    void add(RouteImpl route) {
        this.routes.add(route);
    }

    void remove(RouteImpl route) {
        this.routes.remove(route);
    }

    Vertx vertx() {
        return this.vertx;
    }

    Iterator<RouteImpl> iterator() {
        return this.routes.iterator();
    }

    Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    private String getAndCheckRoutePath(RoutingContext ctx) {
        Route currentRoute = ctx.currentRoute();
        String path = currentRoute.getPath();
        if (path == null) {
            throw new IllegalStateException("Sub routers must be mounted on constant paths (no regex or patterns)");
        }
        return path;
    }
}

