/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.templ.ThymeleafTemplateEngine;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolver;

public class ThymeleafTemplateEngineImpl
implements ThymeleafTemplateEngine {
    private final TemplateEngine engine = new TemplateEngine();
    private final TemplateResolver templateResolver;
    private final ResourceResolver resolver = new ResourceResolver();

    public ThymeleafTemplateEngineImpl() {
        this.templateResolver = new TemplateResolver();
        this.templateResolver.setTemplateMode("XHTML");
        this.templateResolver.setResourceResolver((IResourceResolver)this.resolver);
        this.engine.setTemplateResolver((ITemplateResolver)this.templateResolver);
    }

    @Override
    public ThymeleafTemplateEngine setMode(String mode) {
        this.templateResolver.setTemplateMode(mode);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(RoutingContext context, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        final Buffer buffer = Buffer.buffer();
        try {
            VariablesMap data = new VariablesMap();
            data.put((Object)"context", (Object)context);
            ThymeleafTemplateEngineImpl thymeleafTemplateEngineImpl = this;
            synchronized (thymeleafTemplateEngineImpl) {
                this.resolver.setVertx(context.vertx());
                this.engine.process(templateFileName, (IContext)new WebIContext(data), new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) throws IOException {
                        buffer.appendString(new String(cbuf, off, len));
                    }

                    @Override
                    public void flush() throws IOException {
                    }

                    @Override
                    public void close() throws IOException {
                    }
                });
            }
            handler.handle((Object)Future.succeededFuture((Object)buffer));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    @Override
    public TemplateEngine getThymeleafTemplateEngine() {
        return this.engine;
    }

    private static class ResourceResolver
    implements IResourceResolver {
        private Vertx vertx;

        private ResourceResolver() {
        }

        void setVertx(Vertx vertx) {
            this.vertx = vertx;
        }

        public String getName() {
            return "vertx-web/Thymeleaf";
        }

        public InputStream getResourceAsStream(TemplateProcessingParameters templateProcessingParameters, String resourceName) {
            String str = Utils.readFileToString(this.vertx, resourceName);
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes("UTF-8"));
                BufferedInputStream buis = new BufferedInputStream(bis);
                return buis;
            }
            catch (UnsupportedEncodingException e) {
                throw new VertxException((Throwable)e);
            }
        }
    }

    private static class WebIContext
    implements IContext {
        private final VariablesMap<String, Object> data;

        private WebIContext(VariablesMap<String, Object> data) {
            this.data = data;
        }

        public VariablesMap<String, Object> getVariables() {
            return this.data;
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public void addContextExecutionInfo(String templateName) {
        }
    }
}

