/*
 * Decompiled with CFR 0.152.
 */
package brave.context.jfr;

import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;

public final class JfrScopeDecorator
implements CurrentTraceContext.ScopeDecorator {
    static final CurrentTraceContext.ScopeDecorator INSTANCE = new JfrScopeDecorator();

    public static CurrentTraceContext.ScopeDecorator get() {
        return INSTANCE;
    }

    public CurrentTraceContext.Scope decorateScope(@Nullable TraceContext context, final CurrentTraceContext.Scope scope) {
        if (scope == CurrentTraceContext.Scope.NOOP) {
            return scope;
        }
        final ScopeEvent event = new ScopeEvent();
        if (!event.isEnabled()) {
            return scope;
        }
        if (context != null) {
            event.traceId = context.traceIdString();
            event.parentId = context.parentIdString();
            event.spanId = context.spanIdString();
        }
        event.begin();
        class JfrCurrentTraceContextScope
        implements CurrentTraceContext.Scope {
            JfrCurrentTraceContextScope() {
            }

            public void close() {
                scope.close();
                event.commit();
            }
        }
        return new JfrCurrentTraceContextScope();
    }

    JfrScopeDecorator() {
    }

    @Category(value={"Zipkin"})
    @Label(value="Scope")
    @Description(value="Zipkin event representing a span being placed in scope")
    static final class ScopeEvent
    extends Event {
        @Label(value="Trace Id")
        String traceId;
        @Label(value="Parent Id")
        String parentId;
        @Label(value="Span Id")
        String spanId;

        ScopeEvent() {
        }
    }
}

