/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.Span;
import brave.grpc.GrpcServerRequest;
import brave.grpc.GrpcServerResponse;
import brave.grpc.GrpcTracing;
import brave.internal.Throwables;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.rpc.RpcServerHandler;
import brave.rpc.RpcServerRequest;
import brave.rpc.RpcServerResponse;
import brave.rpc.RpcTracing;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class TracingServerInterceptor
implements ServerInterceptor {
    final Map<String, Metadata.Key<String>> nameToKey;
    final CurrentTraceContext currentTraceContext;
    final RpcServerHandler handler;

    TracingServerInterceptor(GrpcTracing grpcTracing) {
        this.nameToKey = grpcTracing.nameToKey;
        this.currentTraceContext = grpcTracing.rpcTracing.tracing().currentTraceContext();
        this.handler = RpcServerHandler.create((RpcTracing)grpcTracing.rpcTracing);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ServerCall.Listener result;
        GrpcServerRequest request = new GrpcServerRequest(this.nameToKey, call, headers);
        Span span = this.handler.handleReceive((RpcServerRequest)request);
        AtomicReference<Span> spanRef = new AtomicReference<Span>(span);
        Throwable error = null;
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());
        try {
            result = next.startCall(new TracingServerCall<ReqT, RespT>(call, span, spanRef, request), headers);
        }
        catch (RuntimeException e) {
            error = e;
            throw e;
        }
        catch (Error e) {
            Throwables.propagateIfFatal((Throwable)e);
            error = e;
            throw e;
        }
        finally {
            if (error != null) {
                spanRef.set(null);
                if (span != null) {
                    span.error(error).finish();
                }
            }
            scope.close();
        }
        return new TracingServerCallListener(result, span, spanRef);
    }

    final class TracingServerCallListener<RespT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<RespT> {
        final TraceContext context;
        final AtomicReference<Span> spanRef;

        TracingServerCallListener(ServerCall.Listener<RespT> delegate, Span span, AtomicReference<Span> spanRef) {
            super(delegate);
            this.context = span.context();
            this.spanRef = spanRef;
        }

        public void onMessage(RespT message) {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().onMessage(message);
            }
            finally {
                scope.close();
            }
        }

        public void onHalfClose() {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            Throwable error = null;
            try {
                this.delegate().onHalfClose();
            }
            catch (RuntimeException e) {
                error = e;
                throw e;
            }
            catch (Error e) {
                Throwables.propagateIfFatal((Throwable)e);
                error = e;
                throw e;
            }
            finally {
                Span span;
                if (error != null && (span = (Span)this.spanRef.getAndSet(null)) != null) {
                    span.error(error).finish();
                }
                scope.close();
            }
        }

        public void onCancel() {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().onCancel();
            }
            finally {
                scope.close();
            }
        }

        public void onComplete() {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().onComplete();
            }
            finally {
                scope.close();
            }
        }

        public void onReady() {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().onReady();
            }
            finally {
                scope.close();
            }
        }
    }

    final class TracingServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        final TraceContext context;
        final AtomicReference<Span> spanRef;
        final GrpcServerRequest request;
        final Metadata headers;

        TracingServerCall(ServerCall<ReqT, RespT> delegate, Span span, AtomicReference<Span> spanRef, GrpcServerRequest request) {
            super(delegate);
            this.headers = new Metadata();
            this.context = span.context();
            this.spanRef = spanRef;
            this.request = request;
        }

        public void request(int numMessages) {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().request(numMessages);
            }
            finally {
                scope.close();
            }
        }

        public void sendHeaders(Metadata headers) {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().sendHeaders(headers);
            }
            finally {
                scope.close();
            }
            this.headers.merge(headers);
        }

        public void sendMessage(RespT message) {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().sendMessage(message);
            }
            finally {
                scope.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(Status status, Metadata trailers) {
            GrpcServerResponse response = new GrpcServerResponse(this.request, this.headers, status, trailers);
            Span span = this.spanRef.getAndSet(null);
            if (span != null) {
                TracingServerInterceptor.this.handler.handleSend((RpcServerResponse)response, span);
            }
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().close(status, trailers);
            }
            finally {
                scope.close();
            }
        }
    }
}

