/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient5;

import brave.Span;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.httpclient5.HttpClientUtils;
import brave.httpclient5.HttpRequestWrapper;
import brave.httpclient5.HttpResponseWrapper;
import java.io.IOException;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;

class AsyncExecCallbackWrapper
implements AsyncExecCallback {
    final AsyncExecCallback asyncExecCallback;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
    final Span span;
    final HttpRequestWrapper requestWrapper;
    final HttpClientContext context;

    AsyncExecCallbackWrapper(AsyncExecCallback asyncExecCallback, HttpRequestWrapper requestWrapper, HttpClientHandler<HttpClientRequest, HttpClientResponse> handler, Span span, HttpClientContext context) {
        this.asyncExecCallback = asyncExecCallback;
        this.requestWrapper = requestWrapper;
        this.handler = handler;
        this.span = span;
        this.context = context;
    }

    public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
        this.handleSpan(response);
        return this.asyncExecCallback.handleResponse(response, entityDetails);
    }

    public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
        this.handleSpan(response);
        this.asyncExecCallback.handleInformationResponse(response);
    }

    public void completed() {
        this.asyncExecCallback.completed();
    }

    public void failed(Exception cause) {
        this.handler.handleReceive((HttpClientResponse)new HttpResponseWrapper(null, this.requestWrapper, cause), this.span);
        this.asyncExecCallback.failed(cause);
        HttpClientUtils.closeScope((HttpContext)this.context);
    }

    private void handleSpan(HttpResponse response) {
        this.context.removeAttribute(Span.class.getName());
        if (HttpClientUtils.isLocalCached((HttpContext)this.context, this.span)) {
            this.span.kind(null);
        }
        this.handler.handleReceive((HttpClientResponse)new HttpResponseWrapper(response, this.requestWrapper, null), this.span);
    }
}

