/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient5;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.apache.hc.core5.concurrent.FutureCallback;

final class TraceContextFutureCallback<T>
implements FutureCallback<T> {
    final FutureCallback<T> delegate;
    final CurrentTraceContext currentTraceContext;
    final TraceContext invocationContext;

    TraceContextFutureCallback(FutureCallback<T> delegate, CurrentTraceContext currentTraceContext, TraceContext invocationContext) {
        this.delegate = delegate;
        this.currentTraceContext = currentTraceContext;
        this.invocationContext = invocationContext;
    }

    public void completed(T t) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);){
            this.delegate.completed(t);
        }
    }

    public void failed(Exception e) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);){
            this.delegate.failed(e);
        }
    }

    public void cancelled() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);){
            this.delegate.cancelled();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

