/*
 * Decompiled with CFR 0.152.
 */
package brave.jersey.server;

import brave.Span;
import brave.SpanCustomizer;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.jersey.server.EventParser;
import brave.jersey.server.SpanCustomizingApplicationEventListener;
import brave.propagation.CurrentTraceContext;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

@Provider
public final class TracingApplicationEventListener
implements ApplicationEventListener {
    final CurrentTraceContext currentTraceContext;
    final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;
    final EventParser parser;

    public static ApplicationEventListener create(HttpTracing httpTracing) {
        return new TracingApplicationEventListener(httpTracing, new EventParser());
    }

    @Inject
    TracingApplicationEventListener(HttpTracing httpTracing, EventParser parser) {
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
        this.parser = parser;
    }

    public void onEvent(ApplicationEvent event) {
    }

    public RequestEventListener onRequest(RequestEvent event) {
        if (event.getType() != RequestEvent.Type.START) {
            return null;
        }
        Span span = this.handler.handleReceive((HttpServerRequest)new ContainerRequestWrapper(event.getContainerRequest()));
        return new TracingRequestEventListener(span, this.currentTraceContext.newScope(span.context()));
    }

    static boolean async(RequestEvent event) {
        return event.getUriInfo().getMatchedResourceMethod().isManagedAsyncDeclared() || event.getUriInfo().getMatchedResourceMethod().isSuspendDeclared();
    }

    static final class RequestEventWrapper
    extends HttpServerResponse {
        final RequestEvent event;
        @Nullable
        final Throwable error;
        ContainerRequestWrapper request;

        RequestEventWrapper(RequestEvent event) {
            this.event = event;
            this.error = SpanCustomizingApplicationEventListener.unwrapError(event);
        }

        public Object unwrap() {
            return this.event;
        }

        public ContainerRequestWrapper request() {
            if (this.request == null) {
                this.request = new ContainerRequestWrapper(this.event.getContainerRequest());
            }
            return this.request;
        }

        public Throwable error() {
            return this.error;
        }

        public int statusCode() {
            ContainerResponse response = this.event.getContainerResponse();
            if (response != null) {
                return response.getStatus();
            }
            Throwable error = this.event.getException();
            if (error instanceof MappableException && error.getCause() != null) {
                error = error.getCause();
            }
            if (error instanceof WebApplicationException) {
                return ((WebApplicationException)error).getResponse().getStatus();
            }
            return 0;
        }
    }

    static final class ContainerRequestWrapper
    extends HttpServerRequest {
        final ContainerRequest delegate;

        ContainerRequestWrapper(ContainerRequest delegate) {
            this.delegate = delegate;
        }

        public String route() {
            return SpanCustomizingApplicationEventListener.route(this.delegate);
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getMethod();
        }

        public String path() {
            String result = this.delegate.getPath(false);
            return result.indexOf(47) == 0 ? result : "/" + result;
        }

        public String url() {
            return this.delegate.getUriInfo().getRequestUri().toString();
        }

        public String header(String name) {
            return this.delegate.getHeaderString(name);
        }
    }

    class TracingRequestEventListener
    extends AtomicReference<CurrentTraceContext.Scope>
    implements RequestEventListener {
        final Span span;
        volatile boolean async;

        TracingRequestEventListener(Span span, CurrentTraceContext.Scope scope) {
            super(scope);
            this.span = span;
        }

        public void onEvent(RequestEvent event) {
            switch (event.getType()) {
                case REQUEST_MATCHED: {
                    TracingApplicationEventListener.this.parser.requestMatched(event, (SpanCustomizer)this.span);
                    this.async = TracingApplicationEventListener.async(event);
                    break;
                }
                case REQUEST_FILTERED: 
                case RESOURCE_METHOD_FINISHED: {
                    CurrentTraceContext.Scope maybeScope;
                    if (!this.async || (maybeScope = (CurrentTraceContext.Scope)this.getAndSet(null)) == null) break;
                    maybeScope.close();
                    break;
                }
                case RESOURCE_METHOD_START: {
                    if (!this.async || this.get() != null) break;
                    this.set(TracingApplicationEventListener.this.currentTraceContext.newScope(this.span.context()));
                    break;
                }
                case FINISHED: {
                    CurrentTraceContext.Scope maybeScope;
                    TracingApplicationEventListener.this.handler.handleSend((HttpServerResponse)new RequestEventWrapper(event), this.span);
                    if (this.async || (maybeScope = (CurrentTraceContext.Scope)this.getAndSet(null)) == null) break;
                    maybeScope.close();
                    break;
                }
            }
        }
    }
}

