/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.jakarta.jms.JmsTracing;
import brave.jakarta.jms.TracingMessageConsumer;
import brave.jakarta.jms.TracingMessageListener;
import brave.jakarta.jms.TracingMessageProducer;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import jakarta.jms.XAQueueSession;
import jakarta.jms.XASession;
import jakarta.jms.XATopicSession;
import java.io.Serializable;

class TracingSession
implements QueueSession,
TopicSession {
    final Session delegate;
    final JmsTracing jmsTracing;
    final int types;

    static TracingSession create(Session delegate, JmsTracing jmsTracing) {
        if (delegate instanceof TracingSession) {
            return (TracingSession)delegate;
        }
        return new TracingSession(delegate, jmsTracing);
    }

    TracingSession(Session delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
        int types = 0;
        if (delegate instanceof QueueSession) {
            types |= 2;
        }
        if (delegate instanceof TopicSession) {
            types |= 4;
        }
        if (delegate instanceof XASession) {
            types |= 8;
        }
        if (delegate instanceof XAQueueSession) {
            types |= 0x10;
        }
        if (delegate instanceof XATopicSession) {
            types |= 0x20;
        }
        this.types = types;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.delegate.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.delegate.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.delegate.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.delegate.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.delegate.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.delegate.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.delegate.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.delegate.createTextMessage(text);
    }

    public boolean getTransacted() throws JMSException {
        return this.delegate.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.delegate.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        this.delegate.commit();
    }

    public void rollback() throws JMSException {
        this.delegate.rollback();
    }

    public void close() throws JMSException {
        this.delegate.close();
    }

    public void recover() throws JMSException {
        this.delegate.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.delegate.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.delegate.setMessageListener(TracingMessageListener.create(listener, this.jmsTracing));
    }

    public void run() {
        this.delegate.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return TracingMessageProducer.create(this.delegate.createProducer(destination), this.jmsTracing);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return TracingMessageConsumer.create(this.delegate.createConsumer(destination), this.jmsTracing);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        MessageConsumer mc = this.delegate.createConsumer(destination, messageSelector);
        return TracingMessageConsumer.create(mc, this.jmsTracing);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        MessageConsumer mc = this.delegate.createConsumer(destination, messageSelector, noLocal);
        return TracingMessageConsumer.create(mc, this.jmsTracing);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        MessageConsumer mc = this.delegate.createSharedConsumer(topic, sharedSubscriptionName);
        return TracingMessageConsumer.create(mc, this.jmsTracing);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        MessageConsumer mc = this.delegate.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
        return TracingMessageConsumer.create(mc, this.jmsTracing);
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.delegate.createQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.delegate.createTopic(topicName);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        TopicSubscriber ts = this.delegate.createDurableSubscriber(topic, name);
        return TracingMessageConsumer.create((MessageConsumer)ts, this.jmsTracing);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        TopicSubscriber ts = this.delegate.createDurableSubscriber(topic, name, messageSelector, noLocal);
        return TracingMessageConsumer.create((MessageConsumer)ts, this.jmsTracing);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return TracingMessageConsumer.create(this.delegate.createDurableConsumer(topic, name), this.jmsTracing);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        MessageConsumer mc = this.delegate.createDurableConsumer(topic, name, messageSelector, noLocal);
        return TracingMessageConsumer.create(mc, this.jmsTracing);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        MessageConsumer mc = this.delegate.createSharedDurableConsumer(topic, name);
        return TracingMessageConsumer.create(mc, this.jmsTracing);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        MessageConsumer mc = this.delegate.createSharedDurableConsumer(topic, name, messageSelector);
        return TracingMessageConsumer.create(mc, this.jmsTracing);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.delegate.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.delegate.createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.delegate.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.delegate.createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.delegate.unsubscribe(name);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkQueueSession();
        QueueSession qs = (QueueSession)this.delegate;
        return TracingMessageConsumer.create((MessageConsumer)qs.createReceiver(queue), this.jmsTracing);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.checkQueueSession();
        QueueSession qs = (QueueSession)this.delegate;
        return TracingMessageConsumer.create((MessageConsumer)qs.createReceiver(queue, messageSelector), this.jmsTracing);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkQueueSession();
        QueueSession qs = (QueueSession)this.delegate;
        return TracingMessageProducer.create((MessageProducer)qs.createSender(queue), this.jmsTracing);
    }

    void checkQueueSession() {
        if ((this.types & 2) != 2) {
            throw new IllegalStateException(this.delegate + " is not a QueueSession");
        }
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkTopicSession();
        TopicSession ts = (TopicSession)this.delegate;
        return TracingMessageConsumer.create((MessageConsumer)ts.createSubscriber(topic), this.jmsTracing);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkTopicSession();
        TopicSession ts = (TopicSession)this.delegate;
        return TracingMessageConsumer.create((MessageConsumer)ts.createSubscriber(topic, messageSelector, noLocal), this.jmsTracing);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkTopicSession();
        TopicSession ts = (TopicSession)this.delegate;
        return TracingMessageProducer.create((MessageProducer)ts.createPublisher(topic), this.jmsTracing);
    }

    void checkTopicSession() {
        if ((this.types & 4) != 4) {
            throw new IllegalStateException(this.delegate + " is not a TopicSession");
        }
    }
}

