/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.jakarta.jms.JmsTracing;
import brave.jakarta.jms.TracingConnectionConsumer;
import brave.jakarta.jms.TracingExceptionListener;
import brave.jakarta.jms.TracingSession;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import jakarta.jms.XAConnection;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XATopicConnection;

class TracingConnection
implements QueueConnection,
TopicConnection {
    static final int TYPE_QUEUE = 2;
    static final int TYPE_TOPIC = 4;
    static final int TYPE_XA = 8;
    static final int TYPE_XA_QUEUE = 16;
    static final int TYPE_XA_TOPIC = 32;
    final Connection delegate;
    final JmsTracing jmsTracing;
    final int types;

    static TracingConnection create(Connection delegate, JmsTracing jmsTracing) {
        if (delegate instanceof TracingConnection) {
            return (TracingConnection)delegate;
        }
        return new TracingConnection(delegate, jmsTracing);
    }

    TracingConnection(Connection delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
        int types = 0;
        if (delegate instanceof QueueConnection) {
            types |= 2;
        }
        if (delegate instanceof TopicConnection) {
            types |= 4;
        }
        if (delegate instanceof XAConnection) {
            types |= 8;
        }
        if (delegate instanceof XAQueueConnection) {
            types |= 0x10;
        }
        if (delegate instanceof XATopicConnection) {
            types |= 0x20;
        }
        this.types = types;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return TracingSession.create(this.delegate.createSession(transacted, acknowledgeMode), this.jmsTracing);
    }

    public Session createSession(int sessionMode) throws JMSException {
        return TracingSession.create(this.delegate.createSession(sessionMode), this.jmsTracing);
    }

    public Session createSession() throws JMSException {
        return TracingSession.create(this.delegate.createSession(), this.jmsTracing);
    }

    public String getClientID() throws JMSException {
        return this.delegate.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.delegate.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.delegate.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.delegate.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.delegate.setExceptionListener(TracingExceptionListener.create(listener, this.jmsTracing));
    }

    public void start() throws JMSException {
        this.delegate.start();
    }

    public void stop() throws JMSException {
        this.delegate.stop();
    }

    public void close() throws JMSException {
        this.delegate.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        ConnectionConsumer cc = this.delegate.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
        return TracingConnectionConsumer.create(cc, this.jmsTracing);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        ConnectionConsumer cc = this.delegate.createSharedConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
        return TracingConnectionConsumer.create(cc, this.jmsTracing);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        ConnectionConsumer cc = this.delegate.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
        return TracingConnectionConsumer.create(cc, this.jmsTracing);
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        ConnectionConsumer cc = this.delegate.createSharedDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
        return TracingConnectionConsumer.create(cc, this.jmsTracing);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkQueueConnection();
        QueueSession qs = ((QueueConnection)this.delegate).createQueueSession(transacted, acknowledgeMode);
        return TracingSession.create((Session)qs, this.jmsTracing);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkQueueConnection();
        ConnectionConsumer cc = ((QueueConnection)this.delegate).createConnectionConsumer(queue, messageSelector, sessionPool, maxMessages);
        return TracingConnectionConsumer.create(cc, this.jmsTracing);
    }

    void checkQueueConnection() {
        if ((this.types & 2) != 2) {
            throw new IllegalStateException(this.delegate + " is not a QueueConnection");
        }
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkTopicConnection();
        TopicSession ts = ((TopicConnection)this.delegate).createTopicSession(transacted, acknowledgeMode);
        return TracingSession.create((Session)ts, this.jmsTracing);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkTopicConnection();
        ConnectionConsumer cc = ((TopicConnection)this.delegate).createConnectionConsumer(topic, messageSelector, sessionPool, maxMessages);
        return TracingConnectionConsumer.create(cc, this.jmsTracing);
    }

    void checkTopicConnection() {
        if ((this.types & 4) != 4) {
            throw new IllegalStateException(this.delegate + " is not a TopicConnection");
        }
    }
}

