/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.jakarta.jms.JmsTracing;
import brave.jakarta.jms.TracingServerSession;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSession;
import jakarta.jms.ServerSessionPool;

final class TracingServerSessionPool
implements ServerSessionPool {
    final ServerSessionPool delegate;
    final JmsTracing jmsTracing;

    static ServerSessionPool create(ServerSessionPool delegate, JmsTracing jmsTracing) {
        if (delegate == null) {
            throw new NullPointerException("serverSessionPool == null");
        }
        if (delegate instanceof TracingServerSessionPool) {
            return delegate;
        }
        return new TracingServerSessionPool(delegate, jmsTracing);
    }

    TracingServerSessionPool(ServerSessionPool delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
    }

    public ServerSession getServerSession() throws JMSException {
        return TracingServerSession.create(this.delegate.getServerSession(), this.jmsTracing);
    }
}

