/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.internal.Nullable;
import brave.kafka.clients.KafkaHeaders;
import brave.messaging.ProducerRequest;
import brave.propagation.Propagation;
import org.apache.kafka.clients.producer.ProducerRecord;

final class KafkaProducerRequest
extends ProducerRequest {
    static final Propagation.RemoteGetter<KafkaProducerRequest> GETTER = new Propagation.RemoteGetter<KafkaProducerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public String get(KafkaProducerRequest request, String name) {
            return KafkaHeaders.lastStringHeader(request.delegate.headers(), name);
        }

        public String toString() {
            return "Headers::lastHeader";
        }
    };
    static final Propagation.RemoteSetter<KafkaProducerRequest> SETTER = new Propagation.RemoteSetter<KafkaProducerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public void put(KafkaProducerRequest request, String name, String value) {
            KafkaHeaders.replaceHeader(request.delegate.headers(), name, value);
        }

        public String toString() {
            return "Headers::replace";
        }
    };
    final ProducerRecord<?, ?> delegate;

    KafkaProducerRequest(ProducerRecord<?, ?> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    @Nullable
    public String messageId() {
        return null;
    }

    public Span.Kind spanKind() {
        return Span.Kind.PRODUCER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "send";
    }

    public String channelKind() {
        return "topic";
    }

    public String channelName() {
        return this.delegate.topic();
    }
}

