/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.kafka.streams.BaseTracingProcessor;
import brave.kafka.streams.KafkaStreamsTracing;
import brave.kafka.streams.TracingFixedKeyProcessorContext;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorContext;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;

final class TracingFixedKeyProcessor<KIn, VIn, VOut>
extends BaseTracingProcessor<FixedKeyProcessorContext<KIn, VOut>, FixedKeyRecord<KIn, VIn>, FixedKeyProcessor<KIn, VIn, VOut>>
implements FixedKeyProcessor<KIn, VIn, VOut> {
    TracingFixedKeyProcessor(KafkaStreamsTracing kafkaStreamsTracing, String spanName, FixedKeyProcessor<KIn, VIn, VOut> delegate) {
        super(kafkaStreamsTracing, spanName, delegate);
    }

    @Override
    Headers headers(FixedKeyRecord<KIn, VIn> record) {
        return record.headers();
    }

    @Override
    void process(FixedKeyProcessor<KIn, VIn, VOut> delegate, FixedKeyRecord<KIn, VIn> record) {
        delegate.process(record);
    }

    public void init(FixedKeyProcessorContext<KIn, VOut> context) {
        this.context = context;
        CurrentTraceContext current = this.kafkaStreamsTracing.kafkaTracing.messagingTracing().tracing().currentTraceContext();
        TraceContext traceContext = current.get();
        if (traceContext != null) {
            context = new TracingFixedKeyProcessorContext<KIn, VOut>(context, this.kafkaStreamsTracing.injector, traceContext);
        }
        ((FixedKeyProcessor)this.delegate).init(context);
    }

    public void close() {
        ((FixedKeyProcessor)this.delegate).close();
    }
}

