/*
 * Decompiled with CFR 0.152.
 */
package brave.p6spy;

import com.p6spy.engine.logging.P6LogLoadableOptions;
import com.p6spy.engine.logging.P6LogOptions;
import com.p6spy.engine.spy.P6SpyOptions;
import com.p6spy.engine.spy.option.P6OptionsRepository;
import java.util.LinkedHashMap;
import java.util.Map;

final class TracingP6SpyOptions
extends P6SpyOptions {
    static final String REMOTE_SERVICE_NAME = "remoteServiceName";
    static final String INCLUDE_PARAMETER_VALUES = "includeParameterValues";
    private final P6OptionsRepository optionsRepository;
    private final P6LogLoadableOptions logLoadableOptions;

    TracingP6SpyOptions(P6OptionsRepository optionsRepository) {
        super(optionsRepository);
        this.logLoadableOptions = new P6LogOptions(optionsRepository);
        this.optionsRepository = optionsRepository;
    }

    public void load(Map<String, String> options) {
        super.load(options);
        this.logLoadableOptions.load(options);
        this.optionsRepository.set(String.class, REMOTE_SERVICE_NAME, (Object)options.get(REMOTE_SERVICE_NAME));
        this.optionsRepository.set(Boolean.class, INCLUDE_PARAMETER_VALUES, (Object)options.get(INCLUDE_PARAMETER_VALUES));
    }

    public Map<String, String> getDefaults() {
        LinkedHashMap<String, String> allDefaults = new LinkedHashMap<String, String>(super.getDefaults());
        allDefaults.putAll(this.logLoadableOptions.getDefaults());
        allDefaults.put(INCLUDE_PARAMETER_VALUES, Boolean.FALSE.toString());
        return allDefaults;
    }

    P6LogLoadableOptions getLogOptions() {
        return this.logLoadableOptions;
    }

    String remoteServiceName() {
        return (String)this.optionsRepository.get(String.class, REMOTE_SERVICE_NAME);
    }

    Boolean includeParameterValues() {
        return (Boolean)this.optionsRepository.get(Boolean.class, INCLUDE_PARAMETER_VALUES);
    }
}

