/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Tracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.spring.rabbit.SpringRabbitPropagation;
import brave.spring.rabbit.TracingMessagePostProcessor;
import brave.spring.rabbit.TracingRabbitListenerAdvice;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public final class SpringRabbitTracing {
    static final String RABBIT_EXCHANGE = "rabbit.exchange";
    static final String RABBIT_ROUTING_KEY = "rabbit.routing_key";
    static final String RABBIT_QUEUE = "rabbit.queue";
    final Tracing tracing;
    final TraceContext.Extractor<MessageProperties> extractor;
    final TraceContext.Injector<MessageProperties> injector;
    final List<String> propagationKeys;
    final String remoteServiceName;
    final Field beforePublishPostProcessorsField;

    public static SpringRabbitTracing create(Tracing tracing) {
        if (tracing == null) {
            throw new NullPointerException("tracing == null");
        }
        return new Builder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    SpringRabbitTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.extractor = this.tracing.propagation().extractor(SpringRabbitPropagation.GETTER);
        List keyList = builder.tracing.propagation().keys();
        if (builder.writeB3SingleFormat || keyList.equals(Propagation.B3_SINGLE_STRING.keys())) {
            TraceContext testExtraction = this.extractor.extract((Object)SpringRabbitPropagation.B3_SINGLE_TEST_HEADERS).context();
            if (!SpringRabbitPropagation.TEST_CONTEXT.equals((Object)testExtraction)) {
                throw new IllegalArgumentException("SpringRabbitTracing.Builder.writeB3SingleFormat set, but Tracing.Builder.propagationFactory cannot parse this format!");
            }
            this.injector = SpringRabbitPropagation.B3_SINGLE_INJECTOR;
        } else {
            this.injector = this.tracing.propagation().injector(SpringRabbitPropagation.SETTER);
        }
        this.propagationKeys = keyList;
        this.remoteServiceName = builder.remoteServiceName;
        Field beforePublishPostProcessorsField = null;
        try {
            beforePublishPostProcessorsField = RabbitTemplate.class.getDeclaredField("beforePublishPostProcessors");
            beforePublishPostProcessorsField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        this.beforePublishPostProcessorsField = beforePublishPostProcessorsField;
    }

    public RabbitTemplate newRabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        TracingMessagePostProcessor tracingMessagePostProcessor = new TracingMessagePostProcessor(this);
        rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{tracingMessagePostProcessor});
        return rabbitTemplate;
    }

    public RabbitTemplate decorateRabbitTemplate(RabbitTemplate rabbitTemplate) {
        Collection processors;
        if (this.beforePublishPostProcessorsField == null) {
            return rabbitTemplate;
        }
        try {
            processors = (Collection)this.beforePublishPostProcessorsField.get(rabbitTemplate);
        }
        catch (IllegalAccessException e) {
            return rabbitTemplate;
        }
        TracingMessagePostProcessor tracingMessagePostProcessor = new TracingMessagePostProcessor(this);
        if (processors == null) {
            rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{tracingMessagePostProcessor});
            return rabbitTemplate;
        }
        for (MessagePostProcessor processor : processors) {
            if (!(processor instanceof TracingMessagePostProcessor)) continue;
            return rabbitTemplate;
        }
        ArrayList<TracingMessagePostProcessor> newProcessors = new ArrayList<TracingMessagePostProcessor>(processors.size() + 1);
        newProcessors.addAll(processors);
        newProcessors.add(tracingMessagePostProcessor);
        rabbitTemplate.setBeforePublishPostProcessors(newProcessors.toArray(new MessagePostProcessor[0]));
        return rabbitTemplate;
    }

    public SimpleRabbitListenerContainerFactory newSimpleRabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAdviceChain(new Advice[]{new TracingRabbitListenerAdvice(this)});
        return factory;
    }

    public SimpleRabbitListenerContainerFactory decorateSimpleRabbitListenerContainerFactory(SimpleRabbitListenerContainerFactory factory) {
        Advice[] chain = factory.getAdviceChain();
        TracingRabbitListenerAdvice tracingAdvice = new TracingRabbitListenerAdvice(this);
        if (chain == null) {
            factory.setAdviceChain(new Advice[]{tracingAdvice});
            return factory;
        }
        for (Advice advice : chain) {
            if (!(advice instanceof TracingRabbitListenerAdvice)) continue;
            return factory;
        }
        Advice[] newChain = new Advice[chain.length + 1];
        System.arraycopy(chain, 0, newChain, 0, chain.length);
        newChain[chain.length] = tracingAdvice;
        factory.setAdviceChain(newChain);
        return factory;
    }

    TraceContextOrSamplingFlags extractAndClearHeaders(Message message) {
        MessageProperties messageProperties = message.getMessageProperties();
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)messageProperties);
        Map headers = messageProperties.getHeaders();
        this.clearHeaders(headers);
        return extracted;
    }

    void clearHeaders(Map<String, Object> headers) {
        int length = this.propagationKeys.size();
        for (int i = 0; i < length; ++i) {
            headers.remove(this.propagationKeys.get(i));
        }
    }

    public static final class Builder {
        final Tracing tracing;
        String remoteServiceName = "rabbitmq";
        boolean writeB3SingleFormat;

        Builder(Tracing tracing) {
            this.tracing = tracing;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public Builder writeB3SingleFormat(boolean writeB3SingleFormat) {
            this.writeB3SingleFormat = writeB3SingleFormat;
            return this;
        }

        public SpringRabbitTracing build() {
            return new SpringRabbitTracing(this);
        }
    }
}

