/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.web;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.spring.web.TraceContextListenableFuture;
import brave.spring.web.TracingClientHttpRequestInterceptor;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public final class TracingAsyncClientHttpRequestInterceptor
implements AsyncClientHttpRequestInterceptor {
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    public static AsyncClientHttpRequestInterceptor create(Tracing tracing) {
        return TracingAsyncClientHttpRequestInterceptor.create(HttpTracing.create((Tracing)tracing));
    }

    public static AsyncClientHttpRequestInterceptor create(HttpTracing httpTracing) {
        return new TracingAsyncClientHttpRequestInterceptor(httpTracing);
    }

    @Autowired
    TracingAsyncClientHttpRequestInterceptor(HttpTracing httpTracing) {
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    public ListenableFuture<ClientHttpResponse> intercept(HttpRequest request, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        TraceContextListenableFuture traceContextListenableFuture;
        block8: {
            Span span = this.handler.handleSend((HttpClientRequest)new TracingClientHttpRequestInterceptor.HttpClientRequest(request));
            TraceContext invocationContext = span.context().parentIdAsLong() != 0L ? this.currentTraceContext.get() : null;
            CurrentTraceContext.Scope ws = this.currentTraceContext.newScope(span.context());
            try {
                TraceContextListenableFuture result = execution.executeAsync(request, body);
                result.addCallback(new TraceListenableFutureCallback(span, this.handler));
                TraceContextListenableFuture traceContextListenableFuture2 = traceContextListenableFuture = invocationContext != null ? new TraceContextListenableFuture(result, this.currentTraceContext, invocationContext) : result;
                if (ws == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ws != null) {
                        try {
                            ws.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    }
                    throw throwable;
                }
                catch (IOException | Error | RuntimeException e) {
                    this.handler.handleReceive(null, e, span);
                    throw e;
                }
            }
            ws.close();
        }
        return traceContextListenableFuture;
    }

    static final class TraceListenableFutureCallback
    implements ListenableFutureCallback<ClientHttpResponse> {
        final Span span;
        final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

        TraceListenableFutureCallback(Span span, HttpClientHandler<HttpClientRequest, HttpClientResponse> handler) {
            this.span = span;
            this.handler = handler;
        }

        public void onFailure(Throwable ex) {
            this.handler.handleReceive(null, ex, this.span);
        }

        public void onSuccess(ClientHttpResponse result) {
            this.handler.handleReceive((Object)new TracingClientHttpRequestInterceptor.HttpClientResponse(result), null, this.span);
        }
    }
}

