/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.webmvc;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.servlet.HttpServletAdapter;
import brave.spring.webmvc.HandlerParser;
import brave.spring.webmvc.SpanCustomizingHandlerInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Deprecated
public final class TracingHandlerInterceptor
implements HandlerInterceptor {
    static final Propagation.Getter<HttpServletRequest, String> GETTER = new Propagation.Getter<HttpServletRequest, String>(){

        public String get(HttpServletRequest carrier, String key) {
            return carrier.getHeader(key);
        }

        public String toString() {
            return "HttpServletRequest::getHeader";
        }
    };
    static final HttpServletAdapter ADAPTER = new HttpServletAdapter();
    final Tracer tracer;
    final HttpServerHandler<HttpServletRequest, HttpServletResponse> handler;
    final TraceContext.Extractor<HttpServletRequest> extractor;
    final HandlerParser handlerParser;

    public static HandlerInterceptor create(Tracing tracing) {
        return new TracingHandlerInterceptor(HttpTracing.create((Tracing)tracing), new HandlerParser());
    }

    public static HandlerInterceptor create(HttpTracing httpTracing) {
        return new TracingHandlerInterceptor(httpTracing, new HandlerParser());
    }

    @Autowired
    TracingHandlerInterceptor(HttpTracing httpTracing, HandlerParser handlerParser) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing, (HttpServerAdapter)ADAPTER);
        this.extractor = httpTracing.tracing().propagation().extractor(GETTER);
        this.handlerParser = handlerParser;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) {
        if (request.getAttribute(Tracer.SpanInScope.class.getName()) != null) {
            return true;
        }
        Span span = this.handler.handleReceive(this.extractor, (Object)request);
        request.setAttribute(Tracer.SpanInScope.class.getName(), (Object)this.tracer.withSpanInScope(span));
        SpanCustomizingHandlerInterceptor.setHttpRouteAttribute(request);
        this.handlerParser.preHandle(request, o, (SpanCustomizer)span);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception ex) {
        Span span = this.tracer.currentSpan();
        if (span == null) {
            return;
        }
        ((Tracer.SpanInScope)request.getAttribute(Tracer.SpanInScope.class.getName())).close();
        this.handler.handleSend((Object)ADAPTER.adaptResponse(request, response), (Throwable)ex, span);
    }
}

