/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.http;

import com.github.kristofa.brave.AbstractSpanCollector;
import com.github.kristofa.brave.SpanCollectorMetricsHandler;
import com.github.kristofa.brave.http.AutoValue_HttpSpanCollector_Config;
import com.twitter.zipkin.gen.SpanCodec;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

@Deprecated
public final class HttpSpanCollector
extends AbstractSpanCollector {
    private final String url;
    private final Config config;

    public static HttpSpanCollector create(String baseUrl, SpanCollectorMetricsHandler metrics) {
        return new HttpSpanCollector(baseUrl, Config.builder().build(), metrics);
    }

    public static HttpSpanCollector create(String baseUrl, Config config, SpanCollectorMetricsHandler metrics) {
        return new HttpSpanCollector(baseUrl, config, metrics);
    }

    HttpSpanCollector(String baseUrl, Config config, SpanCollectorMetricsHandler metrics) {
        super(SpanCodec.JSON, metrics, config.flushInterval());
        this.url = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v1/spans";
        this.config = config;
    }

    protected void sendSpans(byte[] json) throws IOException {
        Throwable throwable;
        Object compressor;
        HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
        connection.setConnectTimeout(this.config.connectTimeout());
        connection.setReadTimeout(this.config.readTimeout());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Content-Type", "application/json");
        if (this.config.compressionEnabled()) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
            compressor = new GZIPOutputStream(gzipped);
            throwable = null;
            try {
                ((FilterOutputStream)compressor).write(json);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (compressor != null) {
                    if (throwable != null) {
                        try {
                            ((DeflaterOutputStream)compressor).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((DeflaterOutputStream)compressor).close();
                    }
                }
            }
            json = gzipped.toByteArray();
        }
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(json.length);
        connection.getOutputStream().write(json);
        try {
            InputStream in = connection.getInputStream();
            compressor = null;
            try {
                while (in.read() != -1) {
                }
            }
            catch (Throwable throwable4) {
                compressor = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (compressor != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            ((Throwable)compressor).addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throwable = null;
            try (InputStream err = connection.getErrorStream();){
                if (err != null) {
                    while (err.read() != -1) {
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            throw e;
        }
    }

    public static abstract class Config {
        public static Builder builder() {
            return new AutoValue_HttpSpanCollector_Config.Builder().connectTimeout(10000).readTimeout(60000).compressionEnabled(false).flushInterval(1);
        }

        abstract int connectTimeout();

        abstract int readTimeout();

        abstract int flushInterval();

        abstract boolean compressionEnabled();

        public static interface Builder {
            public Builder connectTimeout(int var1);

            public Builder readTimeout(int var1);

            public Builder flushInterval(int var1);

            public Builder compressionEnabled(boolean var1);

            public Config build();
        }
    }
}

