/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.scribe;

import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorMetricsHandler;
import com.github.kristofa.brave.internal.Util;
import com.github.kristofa.brave.scribe.ScribeClientProvider;
import com.github.kristofa.brave.scribe.ScribeSpanCollectorParams;
import com.github.kristofa.brave.scribe.SpanProcessingThread;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Span;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.thrift.TException;

@Deprecated
public class ScribeSpanCollector
implements SpanCollector,
Closeable {
    private static final String UTF_8 = "UTF-8";
    private static final Logger LOGGER = Logger.getLogger(ScribeSpanCollector.class.getName());
    private final BlockingQueue<Span> spanQueue;
    private final ExecutorService executorService;
    private final List<SpanProcessingThread> spanProcessingThreads = new ArrayList<SpanProcessingThread>();
    private final List<ScribeClientProvider> clientProviders = new ArrayList<ScribeClientProvider>();
    private final List<Future<Integer>> futures = new ArrayList<Future<Integer>>();
    private final Set<BinaryAnnotation> defaultAnnotations = new HashSet<BinaryAnnotation>();
    private final SpanCollectorMetricsHandler metricsHandler;

    public ScribeSpanCollector(String host, int port) {
        this(host, port, new ScribeSpanCollectorParams());
    }

    public ScribeSpanCollector(String host, int port, ScribeSpanCollectorParams params) {
        Util.checkNotBlank((String)host, (String)"Null or empty host", (Object[])new Object[0]);
        Util.checkNotNull((Object)params, (String)"Null params", (Object[])new Object[0]);
        this.metricsHandler = params.getMetricsHandler();
        this.spanQueue = new ArrayBlockingQueue<Span>(params.getQueueSize());
        this.executorService = Executors.newFixedThreadPool(params.getNrOfThreads());
        for (int i = 1; i <= params.getNrOfThreads(); ++i) {
            ScribeClientProvider clientProvider = this.createZipkinCollectorClientProvider(host, port, params);
            SpanProcessingThread spanProcessingThread = new SpanProcessingThread(this.spanQueue, clientProvider, params.getBatchSize(), this.metricsHandler);
            this.spanProcessingThreads.add(spanProcessingThread);
            this.clientProviders.add(clientProvider);
            this.futures.add(this.executorService.submit(spanProcessingThread));
        }
    }

    private ScribeClientProvider createZipkinCollectorClientProvider(String zipkinCollectorHost, int zipkinCollectorPort, ScribeSpanCollectorParams params) {
        ScribeClientProvider clientProvider = new ScribeClientProvider(zipkinCollectorHost, zipkinCollectorPort, params.getSocketTimeout());
        try {
            clientProvider.setup();
        }
        catch (TException e) {
            if (params.failOnSetup()) {
                throw new IllegalStateException(e);
            }
            LOGGER.log(Level.WARNING, "Connection could not be established during setup.", e);
        }
        return clientProvider;
    }

    public void collect(Span span) {
        boolean offer;
        this.metricsHandler.incrementAcceptedSpans(1);
        long start = System.currentTimeMillis();
        if (!this.defaultAnnotations.isEmpty()) {
            for (BinaryAnnotation ba : this.defaultAnnotations) {
                span.addToBinary_annotations(ba);
            }
        }
        if (!(offer = this.spanQueue.offer(span))) {
            LOGGER.warning("Queue rejected Span, span not submitted: " + span);
            this.metricsHandler.incrementDroppedSpans(1);
        } else {
            long end = System.currentTimeMillis();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Adding span to queue took " + (end - start) + "ms.");
            }
        }
    }

    public void addDefaultAnnotation(String key, String value) {
        this.defaultAnnotations.add(BinaryAnnotation.create((String)key, (String)value, null));
    }

    @Override
    public void close() {
        LOGGER.info("Stopping SpanProcessingThread.");
        for (SpanProcessingThread spanProcessingThread : this.spanProcessingThreads) {
            spanProcessingThread.stop();
        }
        for (Future future : this.futures) {
            try {
                Integer spansProcessed = (Integer)future.get();
                LOGGER.info("SpanProcessingThread processed " + spansProcessed + "spans.");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception when getting result of SpanProcessingThread.", e);
            }
        }
        for (ScribeClientProvider scribeClientProvider : this.clientProviders) {
            scribeClientProvider.close();
        }
        this.executorService.shutdown();
        this.metricsHandler.incrementDroppedSpans(this.spanQueue.size());
        LOGGER.info("ScribeSpanCollector closed.");
    }
}

