/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.scribe;

import com.github.kristofa.brave.EmptySpanCollectorMetricsHandler;
import com.github.kristofa.brave.SpanCollectorMetricsHandler;
import com.github.kristofa.brave.internal.Util;

public class ScribeSpanCollectorParams {
    public int DEFAULT_QUEUE_SIZE = 200;
    public int DEFAULT_BATCH_SIZE = 10;
    public int DEFAULT_NR_OF_THREADS = 1;
    public int DEFAULT_SOCKET_TIMEOUT = 5000;
    private int queueSize;
    private int batchSize;
    private int nrOfThreads;
    private int socketTimeout;
    private boolean failOnSetup = true;
    private SpanCollectorMetricsHandler metricsHandler = new EmptySpanCollectorMetricsHandler();

    public ScribeSpanCollectorParams() {
        this.queueSize = this.DEFAULT_QUEUE_SIZE;
        this.batchSize = this.DEFAULT_BATCH_SIZE;
        this.nrOfThreads = this.DEFAULT_NR_OF_THREADS;
        this.socketTimeout = this.DEFAULT_SOCKET_TIMEOUT;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        if (queueSize <= 0) {
            throw new IllegalArgumentException("queueSize must be positive");
        }
        this.queueSize = queueSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be positive");
        }
        this.batchSize = batchSize;
    }

    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    public void setNrOfThreads(int nrOfThreads) {
        if (nrOfThreads <= 0) {
            throw new IllegalArgumentException("nrOfThreads must be positive");
        }
        this.nrOfThreads = nrOfThreads;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        if (socketTimeout < 100) {
            throw new IllegalArgumentException("socketTimeout must be >= 100");
        }
        this.socketTimeout = socketTimeout;
    }

    public void setFailOnSetup(boolean failOnSetup) {
        this.failOnSetup = failOnSetup;
    }

    public boolean failOnSetup() {
        return this.failOnSetup;
    }

    public SpanCollectorMetricsHandler getMetricsHandler() {
        return this.metricsHandler;
    }

    public void setMetricsHandler(SpanCollectorMetricsHandler metricsHandler) {
        this.metricsHandler = (SpanCollectorMetricsHandler)Util.checkNotNull((Object)metricsHandler, (String)"Null metricsHandler", (Object[])new Object[0]);
    }
}

