/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.beans;

import brave.Clock;
import brave.Tracing;
import brave.TracingCustomizer;
import brave.handler.SpanHandler;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.sampler.Sampler;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class TracingFactoryBean
extends AbstractFactoryBean {
    String localServiceName;
    List<SpanHandler> spanHandlers = new ArrayList<SpanHandler>();
    Clock clock;
    Sampler sampler;
    CurrentTraceContext currentTraceContext;
    Propagation.Factory propagationFactory;
    Boolean traceId128Bit;
    Boolean supportsJoin;
    List<TracingCustomizer> customizers;

    protected Tracing createInstance() {
        Tracing.Builder builder = Tracing.newBuilder();
        if (this.localServiceName != null) {
            builder.localServiceName(this.localServiceName);
        }
        for (SpanHandler spanHandler : this.spanHandlers) {
            builder.addSpanHandler(spanHandler);
        }
        if (this.clock != null) {
            builder.clock(this.clock);
        }
        if (this.sampler != null) {
            builder.sampler(this.sampler);
        }
        if (this.currentTraceContext != null) {
            builder.currentTraceContext(this.currentTraceContext);
        }
        if (this.propagationFactory != null) {
            builder.propagationFactory(this.propagationFactory);
        }
        if (this.traceId128Bit != null) {
            builder.traceId128Bit(this.traceId128Bit.booleanValue());
        }
        if (this.supportsJoin != null) {
            builder.supportsJoin(this.supportsJoin.booleanValue());
        }
        if (this.customizers != null) {
            for (TracingCustomizer customizer : this.customizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }

    protected void destroyInstance(Object instance) {
        ((Tracing)instance).close();
    }

    public Class<? extends Tracing> getObjectType() {
        return Tracing.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setLocalServiceName(String localServiceName) {
        this.localServiceName = localServiceName;
    }

    public void setSpanHandlers(List<SpanHandler> spanHandlers) {
        this.spanHandlers.addAll(spanHandlers);
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setSampler(Sampler sampler) {
        this.sampler = sampler;
    }

    public void setCurrentTraceContext(CurrentTraceContext currentTraceContext) {
        this.currentTraceContext = currentTraceContext;
    }

    public void setPropagationFactory(Propagation.Factory propagationFactory) {
        this.propagationFactory = propagationFactory;
    }

    public void setTraceId128Bit(boolean traceId128Bit) {
        this.traceId128Bit = traceId128Bit;
    }

    public void setSupportsJoin(Boolean supportsJoin) {
        this.supportsJoin = supportsJoin;
    }

    public void setCustomizers(List<TracingCustomizer> customizers) {
        this.customizers = customizers;
    }
}

