/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.servlet;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseAdapter;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.http.DefaultSpanNameProvider;
import com.github.kristofa.brave.http.HttpServerRequest;
import com.github.kristofa.brave.http.HttpServerRequestAdapter;
import com.github.kristofa.brave.http.HttpServerResponseAdapter;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.internal.Util;
import com.github.kristofa.brave.servlet.BraveServletFilter$$Lambda$1;
import com.github.kristofa.brave.servlet.BraveServletFilter$$Lambda$2;
import com.github.kristofa.brave.servlet.ServletHttpServerRequest;
import com.github.kristofa.brave.servlet.internal.MaybeAddClientAddressFromRequest;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class BraveServletFilter
implements Filter {
    private final ServerRequestInterceptor requestInterceptor;
    private final ServerResponseInterceptor responseInterceptor;
    private final SpanNameProvider spanNameProvider;
    private final MaybeAddClientAddressFromRequest maybeAddClientAddressFromRequest;
    private FilterConfig filterConfig;

    public static BraveServletFilter create(Brave brave) {
        return new Builder(brave).build();
    }

    public static Builder builder(Brave brave) {
        return new Builder(brave);
    }

    protected BraveServletFilter(Builder b) {
        this.requestInterceptor = b.brave.serverRequestInterceptor();
        this.responseInterceptor = b.brave.serverResponseInterceptor();
        this.spanNameProvider = b.spanNameProvider;
        this.maybeAddClientAddressFromRequest = MaybeAddClientAddressFromRequest.create(b.brave);
    }

    @Deprecated
    public BraveServletFilter(ServerRequestInterceptor requestInterceptor, ServerResponseInterceptor responseInterceptor, SpanNameProvider spanNameProvider) {
        this.requestInterceptor = requestInterceptor;
        this.responseInterceptor = responseInterceptor;
        this.spanNameProvider = spanNameProvider;
        this.maybeAddClientAddressFromRequest = null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        StatusExposingServletResponse statusExposingServletResponse;
        boolean hasAlreadyFilteredAttribute;
        String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
        boolean bl = hasAlreadyFilteredAttribute = request.getAttribute(alreadyFilteredAttributeName) != null;
        if (hasAlreadyFilteredAttribute) {
            filterChain.doFilter(request, response);
            return;
        }
        request.setAttribute(alreadyFilteredAttributeName, (Object)Boolean.TRUE);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        StatusExposingServletResponse statusExposingServletResponse2 = new StatusExposingServletResponse((HttpServletResponse)response);
        this.requestInterceptor.handle((ServerRequestAdapter)new HttpServerRequestAdapter((HttpServerRequest)new ServletHttpServerRequest(httpRequest), this.spanNameProvider));
        if (this.maybeAddClientAddressFromRequest != null) {
            this.maybeAddClientAddressFromRequest.accept(httpRequest);
        }
        try {
            filterChain.doFilter(request, (ServletResponse)statusExposingServletResponse2);
            statusExposingServletResponse = statusExposingServletResponse2;
        }
        catch (Throwable throwable) {
            StatusExposingServletResponse statusExposingServletResponse3 = statusExposingServletResponse2;
            Objects.requireNonNull(statusExposingServletResponse3);
            this.responseInterceptor.handle((ServerResponseAdapter)new HttpServerResponseAdapter(BraveServletFilter$$Lambda$2.lambdaFactory$(statusExposingServletResponse3)));
            throw throwable;
        }
        Objects.requireNonNull(statusExposingServletResponse);
        this.responseInterceptor.handle((ServerResponseAdapter)new HttpServerResponseAdapter(BraveServletFilter$$Lambda$1.lambdaFactory$(statusExposingServletResponse)));
    }

    public void destroy() {
    }

    private String getAlreadyFilteredAttributeName() {
        String name = this.getFilterName();
        if (name == null) {
            name = this.getClass().getName();
        }
        return name + ".FILTERED";
    }

    private final String getFilterName() {
        return this.filterConfig != null ? this.filterConfig.getFilterName() : null;
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus = 200;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public int getStatus() {
            return this.httpStatus;
        }
    }

    public static final class Builder {
        final Brave brave;
        SpanNameProvider spanNameProvider = new DefaultSpanNameProvider();

        Builder(Brave brave) {
            this.brave = (Brave)Util.checkNotNull((Object)brave, (String)"brave", (Object[])new Object[0]);
        }

        public Builder spanNameProvider(SpanNameProvider spanNameProvider) {
            this.spanNameProvider = (SpanNameProvider)Util.checkNotNull((Object)spanNameProvider, (String)"spanNameProvider", (Object[])new Object[0]);
            return this;
        }

        public BraveServletFilter build() {
            return new BraveServletFilter(this);
        }
    }
}

