/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.internal;

import java.io.IOException;
import java.lang.reflect.Constructor;

public abstract class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    public RuntimeException uncheckedIOException(IOException e) {
        return new RuntimeException(e);
    }

    public static Platform get() {
        return PLATFORM;
    }

    static Platform findPlatform() {
        try {
            Class<?> clazz = Class.forName("java.io.UncheckedIOException");
            Constructor<?> ctor = clazz.getConstructor(IOException.class);
            return new Jre8(ctor);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Jre6.build();
    }

    static final class Jre6
    extends Platform {
        Jre6() {
        }

        static Jre6 build() {
            return new Jre6();
        }
    }

    static final class Jre8
    extends Platform {
        final Constructor<?> uncheckedIOExceptionCtor;

        Jre8(Constructor<?> uncheckedIOExceptionCtor) {
            this.uncheckedIOExceptionCtor = uncheckedIOExceptionCtor;
        }

        @Override
        public RuntimeException uncheckedIOException(IOException e) {
            try {
                return (RuntimeException)this.uncheckedIOExceptionCtor.newInstance(e);
            }
            catch (Exception unexpected) {
                return new RuntimeException(e);
            }
        }
    }
}

