/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.brave.internal;

import zipkin2.reporter.brave.internal.WriteBuffer;
import zipkin2.reporter.internal.Nullable;

class IpWriter {
    static final int IPV6_PART_COUNT = 8;
    static final char IPV6_DELIMITER = ':';

    IpWriter() {
    }

    @Nullable
    static void writeIpv4Bytes(WriteBuffer b, @Nullable String ipv4) {
        if (ipv4 == null) {
            return;
        }
        int i = 0;
        int len = ipv4.length();
        while (i < len) {
            char ch = ipv4.charAt(i++);
            int octet = ch - 48;
            if (i == len || (ch = ipv4.charAt(i++)) == '.') {
                b.writeByte((byte)octet);
                continue;
            }
            octet = octet * 10 + (ch - 48);
            if (i == len || (ch = ipv4.charAt(i++)) == '.') {
                b.writeByte((byte)octet);
                continue;
            }
            octet = octet * 10 + (ch - 48);
            b.writeByte((byte)octet);
            ++i;
        }
    }

    @Nullable
    static void writeIpv6Bytes(WriteBuffer b, @Nullable String ipString) {
        if (ipString == null) {
            return;
        }
        int delimiterCount = IpWriter.countColon(ipString);
        if (delimiterCount < 2 || delimiterCount > 8) {
            return;
        }
        int partsSkipped = 8 - (delimiterCount + 1);
        boolean hasSkip = false;
        for (int i = 0; i < ipString.length() - 1; ++i) {
            if (ipString.charAt(i) != ':' || ipString.charAt(i + 1) != ':') continue;
            if (hasSkip) {
                return;
            }
            hasSkip = true;
            ++partsSkipped;
            if (i == 0) {
                ++partsSkipped;
            }
            if (i != ipString.length() - 2) continue;
            ++partsSkipped;
        }
        if (ipString.charAt(0) == ':' && ipString.charAt(1) != ':') {
            return;
        }
        if (ipString.charAt(ipString.length() - 1) == ':' && ipString.charAt(ipString.length() - 2) != ':') {
            return;
        }
        if (hasSkip && partsSkipped <= 0) {
            return;
        }
        if (!hasSkip && delimiterCount + 1 != 8) {
            return;
        }
        try {
            int start = 0;
            if (ipString.charAt(0) == ':') {
                start = 1;
            }
            while (start < ipString.length()) {
                int end = ipString.indexOf(58, start);
                if (end == -1) {
                    end = ipString.length();
                }
                if (ipString.charAt(start) == ':') {
                    for (int i = 0; i < partsSkipped; ++i) {
                        b.writeShort((short)0);
                    }
                } else {
                    b.writeShort(IpWriter.parseHextet(ipString, start, end));
                }
                start = end + 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static int countColon(CharSequence sequence) {
        int count = 0;
        for (int i = 0; i < sequence.length(); ++i) {
            if (sequence.charAt(i) != ':') continue;
            ++count;
        }
        return count;
    }

    static short parseHextet(String ipString, int start, int end) {
        int length = end - start;
        if (length <= 0 || length > 4) {
            throw new NumberFormatException();
        }
        int hextet = 0;
        for (int i = start; i < end; ++i) {
            hextet <<= 4;
            hextet |= Character.digit(ipString.charAt(i), 16);
        }
        return (short)hextet;
    }
}

