/*
 * CREDIT SUISSE IS WILLING TO LICENSE THIS SPECIFICATION TO YOU ONLY UPON THE CONDITION THAT YOU
 * ACCEPT ALL OF THE TERMS CONTAINED IN THIS AGREEMENT. PLEASE READ THE TERMS AND CONDITIONS OF THIS
 * AGREEMENT CAREFULLY. BY DOWNLOADING THIS SPECIFICATION, YOU ACCEPT THE TERMS AND CONDITIONS OF
 * THE AGREEMENT. IF YOU ARE NOT WILLING TO BE BOUND BY IT, SELECT THE "DECLINE" BUTTON AT THE
 * BOTTOM OF THIS PAGE. Specification: JSR-354 Money and Currency API ("Specification") Copyright
 * (c) 2012-2013, Credit Suisse All rights reserved.
 */
package javax.money;

/**
 * Interface representing a monetary rounding. Rounding must not necessarily represent roundings in a pure arithmetical sense. Basically a rounding
 * can scale an amount arbitrarily.
 * <h4>Implementation specification</h4>
 * Implementations of this interface must be
 * <ul>
 *     <li>final</li>
 *     <li>immutable</li>
 *     <li>thread-safe</li>
 * </ul>
 * Implementations of this interface should be
 * <ul>
 *     <li>serializable</li>
 * </ul>
 */
public interface MonetaryRounding extends MonetaryOperator{

    /**
     * Access the rounding's context, which gives more details of the rounding instances such as
     * <ul>
     *     <li>The rounding's name (required)</li>
     *     <li>Its provider (required)</li>
     *     <li>Its base currency</li>
     *     <li>its scale and rounding mode</li>
     *     <li>any other attributes useful to describe the rounding</li>
     * </ul>
     * @return the rounding's context, never null.
     */
    RoundingContext getRoundingContext();

}
