/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package javax.ws.rs.container;

import java.io.IOException;

/**
 * An extension interface implemented by container response filters.
 *
 * By default, i.e. if no {@link javax.ws.rs.NameBinding name binding} is applied
 * to the filter implementation class, the {@code filter(...)} method is called
 * globally for all responses, i.e. even in case an actual resource matching
 * failed or has not been performed at all.
 * If there is a {@link javax.ws.rs.NameBinding &#64;NameBinding} annotation
 * applied to the filter, the filter will be executed only for responses
 * created for requests that were successfully matched to a resource method.
 * <p />
 * Implement a name-bound response filter in cases when you want limit the filter
 * functionality to a particular resource or resource method or if you depend on
 * a matched resource information in your filter processing. In other cases,
 * when the filter should be applied globally to all responses, even in those
 * cases when a request has not been matched to a resource implement an unbound
 * response filter.
 * <p />
 * Filters implementing this interface must be annotated with
 * {@link javax.ws.rs.ext.Provider &#64;Provider} to be discovered by the JAX-RS
 * runtime. Container response filter instances may also be discovered and
 * bound {@link DynamicBinder dynamically} to particular resource methods.
 *
 * @author Marek Potociar
 * @author Santiago Pericas-Geertsen
 *
 * @since 2.0
 *
 * @see javax.ws.rs.container.PostMatching
 * @see javax.ws.rs.container.ContainerRequestFilter
 */
public interface ContainerResponseFilter {

    /**
     * Filter method called after a response has been provided for a request
     * (either by a {@link ContainerRequestFilter request filter} or by a
     * matched resource method.
     *
     * By default, i.e. if no {@link javax.ws.rs.NameBinding name binding} is applied
     * to the filter implementation class, the {@code filter(...)} method is called
     * globally for all responses, i.e. even in case an actual resource matching
     * failed or has not been performed at all.
     * If there is a {@link javax.ws.rs.NameBinding &#64;NameBinding} annotation
     * applied to the filter, the filter will be executed only for responses
     * created for requests that were successfully matched to a resource method.
     * <p />
     * Filters in the filter chain are ordered according to their binding
     * priority (see {@link javax.ws.rs.BindingPriority}).
     *
     * @param requestContext request context.
     * @param responseContext response context.
     * @throws IOException if an I/O exception occurs.
     *
     * @see javax.ws.rs.container.PostMatching
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext)
            throws IOException;
}
