/*
 * Decompiled with CFR 0.152.
 */
package jp.co.worksap.jax_rs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.UriBuilder;

public class ApiScriptGenerator {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private final Class<?>[] controllers;

    public ApiScriptGenerator(Class<?> ... controllers) {
        this.controllers = controllers;
    }

    public void execute(File outputDir, String metaTagName, String dataNameToGetContextPath) throws IOException {
        Preconditions.checkNotNull((Object)outputDir);
        Preconditions.checkArgument((boolean)outputDir.isDirectory());
        for (Class<?> clazz : this.controllers) {
            File js = new File(outputDir, this.createModuleNameOf(clazz) + ".js");
            this.write(clazz, js, metaTagName, dataNameToGetContextPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Class<?> clazz, File js, String metaTagName, String dataNameToGetContextPath) throws IOException {
        Function<String, String> createJsonPair = new Function<String, String>(){

            public String apply(String input) {
                return String.format("'%s':%s", input, input);
            }
        };
        BufferedWriter writer = Files.newWriter((File)js, (Charset)Charsets.UTF_8);
        try {
            Method[] methods;
            writer.write("// auto generated by ");
            writer.write(this.getClass().getName());
            writer.write("\ndefine(");
            writer.write("['jquery', 'exports'], function($, exports) {\n  'use strict';\n");
            String scriptToGetBaseURL = this.makeScriptToGetBaseURL(metaTagName, dataNameToGetContextPath);
            writer.write(scriptToGetBaseURL);
            for (Method method : methods = clazz.getMethods()) {
                if (!method.getDeclaringClass().equals(clazz)) continue;
                this.writeMethod(clazz, createJsonPair, writer, method);
            }
            writer.write("});");
        }
        finally {
            writer.close();
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    @VisibleForTesting
    String makeScriptToGetBaseURL(String metaTagName, String dataNameToGetContextPath) {
        Preconditions.checkNotNull((Object)metaTagName);
        Preconditions.checkNotNull((Object)dataNameToGetContextPath);
        String scriptToGetBaseURL = String.format("  var baseURL = $('meta[name=\"%s\"]').data('%s') + '/resources';\n", this.escape(metaTagName), this.escape(dataNameToGetContextPath));
        return scriptToGetBaseURL;
    }

    @Nonnull
    private String escape(@Nonnull String htmlAttributeValue) {
        return htmlAttributeValue.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&#x22;").replaceAll("'", "&#x27;").replaceAll("/", "&#x2F;");
    }

    private List<String> writeMethod(Class<?> clazz, Function<String, String> createJsonPair, BufferedWriter writer, Method method) throws IOException {
        List<String> argumentName = this.getArgumentName(method);
        writer.write("  exports.");
        writer.write(method.getName());
        writer.write(" = function (");
        writer.write(COMMA_JOINER.join(argumentName));
        writer.write(") {\n");
        writer.write("    return $.ajax({\n        cache: false,\n        url: baseURL + ");
        writer.write(this.getPathOf(clazz, method));
        writer.write(",\n        type: '");
        writer.write(this.getTypeOf(method));
        writer.write("',\n        data: {");
        writer.write(COMMA_JOINER.join(Iterators.transform(this.getFormOrQueryParamName(method).iterator(), createJsonPair)));
        writer.write("}\n    }).promise();\n  };\n");
        return argumentName;
    }

    private String createModuleNameOf(Class<?> clazz) {
        StringBuilder result = new StringBuilder(clazz.getSimpleName());
        result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        return result.toString();
    }

    private String getPathOf(Class<?> clazz, Method method) {
        UriBuilder builder = UriBuilder.fromResource(clazz).path(method);
        HashMap pathParams = Maps.newHashMap();
        for (String pathParam : this.getPathParamName(method)) {
            pathParams.put(pathParam, "' + encodeURI(" + pathParam + ") + '");
        }
        String path = "'" + builder.buildFromMap((Map)pathParams).getPath();
        path = path.endsWith(" + '") ? path.substring(0, path.length() - " + '".length()) : path + '\'';
        return path;
    }

    private List<String> getArgumentName(Method method) {
        List<String> params = this.getPathParamName(method);
        List<String> formParams = this.getFormOrQueryParamName(method);
        params.addAll(formParams);
        return params;
    }

    private List<String> getFormOrQueryParamName(Method method) {
        ArrayList argumentName = Lists.newArrayList();
        Annotation[][] arr$ = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] perMethod;
            for (Annotation annotation : perMethod = arr$[i$]) {
                FormParam param;
                if (annotation instanceof FormParam) {
                    param = (FormParam)annotation;
                    argumentName.add(param.value());
                    continue;
                }
                if (!(annotation instanceof QueryParam)) continue;
                param = (QueryParam)annotation;
                argumentName.add(param.value());
            }
        }
        return argumentName;
    }

    private List<String> getPathParamName(Method method) {
        ArrayList argumentName = Lists.newArrayList();
        Annotation[][] arr$ = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] perMethod;
            for (Annotation annotation : perMethod = arr$[i$]) {
                if (!(annotation instanceof PathParam)) continue;
                PathParam param = (PathParam)annotation;
                argumentName.add(param.value());
            }
        }
        return argumentName;
    }

    private String getTypeOf(Method method) {
        if (method.getAnnotation(GET.class) != null) {
            return "get";
        }
        if (method.getAnnotation(POST.class) != null) {
            return "post";
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return "delete";
        }
        if (method.getAnnotation(PUT.class) != null) {
            return "put";
        }
        throw new IllegalArgumentException(method.getName() + " has no annotation like @GET");
    }
}

