/*
 * Decompiled with CFR 0.152.
 */
package jp.co.worksap.jax_rs;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import jp.co.worksap.jax_rs.ApiScriptGenerator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public final class GenerateMojo
extends AbstractMojo {
    protected String packageName;
    protected File outputDirectory;
    private MavenProject project;
    private String metaTagName;
    private String dataNameToGetContextPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.outputDirectory.mkdirs();
        this.deleteChildren(this.outputDirectory, this.getLog());
        String[] controllerNames = this.listControllerNames();
        try {
            URLClassLoader newLoader = this.createClassLoader();
            Class<?>[] controllerClasses = this.loadClasses(newLoader, controllerNames);
            Class<?> generatorClass = newLoader.loadClass(ApiScriptGenerator.class.getName());
            Constructor<?> constructor = generatorClass.getConstructor(Class[].class);
            Object generator = constructor.newInstance(new Object[]{controllerClasses});
            Method execute = generatorClass.getMethod("execute", File.class, String.class, String.class);
            execute.invoke(generator, this.outputDirectory, this.metaTagName, this.dataNameToGetContextPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException occurs", (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("DependencyResolutionRequiredException occurs", (Exception)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("ClassNotFoundException occurs", (Exception)e);
        }
        catch (SecurityException e) {
            throw new MojoExecutionException("SecurityException occurs", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("NoSuchMethodException occurs", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("InstantiationException occurs", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("IllegalAccessException occurs", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("InvocationTargetException occurs", (Exception)e);
        }
    }

    private Class<?>[] loadClasses(URLClassLoader newLoader, String[] controllerNames) throws MalformedURLException, DependencyResolutionRequiredException, ClassNotFoundException {
        ArrayList result = Lists.newArrayList();
        for (String name : controllerNames) {
            result.add(newLoader.loadClass(name));
        }
        Thread.currentThread().setContextClassLoader(newLoader);
        return result.toArray(new Class[result.size()]);
    }

    private URLClassLoader createClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        List classpathElements = this.project.getCompileClasspathElements();
        for (Object o : this.project.getDependencyArtifacts()) {
            Artifact a = (Artifact)o;
            classpathElements.add(a.getFile().getAbsolutePath());
        }
        URL[] runtimeUrls = new URL[classpathElements.size()];
        for (int i = 0; i < classpathElements.size(); ++i) {
            String element = (String)classpathElements.get(i);
            runtimeUrls[i] = new File(element).toURI().toURL();
        }
        URLClassLoader newLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
        return newLoader;
    }

    private String[] listControllerNames() {
        File controllerDir = this.searchControllerDirectory();
        ArrayList result = Lists.newArrayList();
        if (!controllerDir.exists() || !controllerDir.isDirectory()) {
            this.getLog().warn((CharSequence)"There is no file in controller directory.");
            return new String[0];
        }
        for (File file : controllerDir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".java")) continue;
            result.add(this.packageName + '.' + this.dropExtension(file.getName()));
        }
        return result.toArray(new String[result.size()]);
    }

    private File searchControllerDirectory() {
        Log logger = this.getLog();
        File baseDir = this.project.getBasedir();
        logger.info((CharSequence)("Base directory of project is:" + baseDir.getAbsolutePath()));
        File sourceDir = new File(baseDir, "src/main/java");
        File controllerDir = new File(sourceDir, this.packageName.replace('.', File.separatorChar));
        logger.info((CharSequence)("Controller directory is:" + controllerDir.getAbsolutePath()));
        return controllerDir;
    }

    String dropExtension(String name) {
        int index = name.indexOf(46);
        return name.substring(0, index);
    }

    private void deleteChildren(File directory, Log log) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.deleteChildren(file, log);
            }
            if (file.delete()) continue;
            log.warn((CharSequence)("Failed to remove old JavaScript API component. File name is: " + file.getAbsolutePath()));
        }
    }
}

