/*
 * Decompiled with CFR 0.152.
 */
package lk.chathurabuddi.json.schema.filter;

import java.util.Collection;
import lk.chathurabuddi.json.schema.constants.FreeFormAction;
import lk.chathurabuddi.json.schema.constants.SchemaKeyWord;
import lk.chathurabuddi.json.schema.exceptions.InvalidSchemaException;
import lk.chathurabuddi.json.schema.exceptions.JsonParseException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonSchemaFilter {
    private final String schemaStr;
    private final String sourceJsonStr;
    private final FreeFormAction freeFormAction;

    public JsonSchemaFilter(String schema, String sourceJson) {
        this(schema, sourceJson, FreeFormAction.ATTACH);
    }

    public JsonSchemaFilter(String schemaStr, String sourceJsonStr, FreeFormAction freeFormAction) {
        this.schemaStr = schemaStr;
        this.sourceJsonStr = sourceJsonStr;
        this.freeFormAction = freeFormAction;
    }

    public String filter() throws InvalidSchemaException, JsonParseException {
        JSONParser parser = new JSONParser();
        try {
            JSONObject schema = (JSONObject)parser.parse(this.schemaStr);
            if (SchemaKeyWord.OBJECT.value().equals(schema.get((Object)SchemaKeyWord.TYPE.value()))) {
                return this.filter(schema, (JSONObject)parser.parse(this.sourceJsonStr)).toJSONString();
            }
            if (SchemaKeyWord.ARRAY.value().equals(schema.get((Object)SchemaKeyWord.TYPE.value()))) {
                return this.filter(schema, (JSONArray)parser.parse(this.sourceJsonStr)).toJSONString();
            }
            throw new InvalidSchemaException();
        }
        catch (ParseException exception) {
            throw new JsonParseException(exception);
        }
    }

    private JSONObject filter(JSONObject schema, JSONObject sourceJson) {
        JSONObject resultJson = new JSONObject();
        if (!schema.containsKey((Object)SchemaKeyWord.PROPERTIES.value()) && !sourceJson.keySet().isEmpty()) {
            return this.freeFormAction == FreeFormAction.DETACH ? resultJson : sourceJson;
        }
        JSONObject schemaProperties = (JSONObject)schema.get((Object)SchemaKeyWord.PROPERTIES.value());
        schemaProperties.keySet().forEach(key -> {
            Object sourceProperty = sourceJson.get(key);
            if (sourceProperty == null) {
                if (sourceJson.containsKey(key)) {
                    resultJson.put(key, null);
                }
            } else {
                JSONObject schemaProperty = (JSONObject)schemaProperties.get(key);
                String schemaPropertyType = (String)schemaProperty.get((Object)SchemaKeyWord.TYPE.value());
                if (SchemaKeyWord.OBJECT.value().equals(schemaPropertyType)) {
                    resultJson.put(key, (Object)this.filter(schemaProperty, (JSONObject)sourceProperty));
                } else if (SchemaKeyWord.ARRAY.value().equals(schemaPropertyType)) {
                    resultJson.put(key, (Object)this.filter(schemaProperty, (JSONArray)sourceProperty));
                } else {
                    resultJson.put(key, sourceProperty);
                }
            }
        });
        return resultJson;
    }

    private JSONArray filter(JSONObject schema, JSONArray sourceJson) {
        JSONArray resultJson = new JSONArray();
        JSONObject arrayItems = (JSONObject)schema.get((Object)SchemaKeyWord.ITEMS.value());
        if (SchemaKeyWord.OBJECT.value().equals(arrayItems.get((Object)SchemaKeyWord.TYPE.value()))) {
            for (Object item : sourceJson) {
                resultJson.add((Object)this.filter(arrayItems, (JSONObject)item));
            }
        } else if (SchemaKeyWord.ARRAY.value().equals(arrayItems.get((Object)SchemaKeyWord.TYPE.value()))) {
            for (Object item : sourceJson) {
                resultJson.add((Object)this.filter(arrayItems, (JSONArray)item));
            }
        } else if (arrayItems.get((Object)SchemaKeyWord.TYPE.value()) != null) {
            resultJson.addAll((Collection)sourceJson);
        }
        return resultJson;
    }
}

