/*
 * Decompiled with CFR 0.152.
 */
package net.sf.maventaglib.checker;

import java.lang.constant.Constable;
import net.sf.maventaglib.checker.Tag;
import net.sf.maventaglib.checker.TagAttribute;
import net.sf.maventaglib.checker.Tld;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.tree.DefaultDocument;
import org.dom4j.tree.DefaultElement;

public class TldChecker {
    private static Log log = LogFactory.getLog((Class)(class$net$sf$maventaglib$checker$TldChecker == null ? (class$net$sf$maventaglib$checker$TldChecker = TldChecker.class$("net.sf.maventaglib.checker.TldChecker")) : class$net$sf$maventaglib$checker$TldChecker));
    static /* synthetic */ Class class$net$sf$maventaglib$checker$TldChecker;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$TagSupport;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$TagExtraInfo;
    static /* synthetic */ Class class$java$lang$String;

    public Document check(Tld[] tlds) {
        DefaultDocument doc = new DefaultDocument();
        DefaultElement document = new DefaultElement("document");
        doc.add((Element)document);
        for (int j = 0; j < tlds.length; ++j) {
            Element tldNode = this.checkTld(tlds[j]);
            document.add(tldNode);
        }
        return doc;
    }

    private Element checkTld(Tld tld) {
        DefaultElement section = new DefaultElement("tld");
        section.addAttribute("name", tld.getName());
        section.addAttribute("file", tld.getFilename());
        Tag[] tags = tld.getTags();
        if (tags != null) {
            for (int j = 0; j < tags.length; ++j) {
                Element tagNode = this.checkTag(tags[j]);
                section.add(tagNode);
            }
        }
        return section;
    }

    private Element checkTag(Tag tag) {
        DefaultElement subsection = new DefaultElement("tag");
        String className = tag.getTagClass();
        subsection.addAttribute("name", tag.getName());
        DefaultElement tagImpl = new DefaultElement("tagclass");
        tagImpl.addAttribute("name", className);
        subsection.add((Element)tagImpl);
        Object tagObject = null;
        try {
            Class<?> tagClass = Class.forName(className);
            if (!(class$javax$servlet$jsp$tagext$TagSupport == null ? (class$javax$servlet$jsp$tagext$TagSupport = TldChecker.class$("javax.servlet.jsp.tagext.TagSupport")) : class$javax$servlet$jsp$tagext$TagSupport).isAssignableFrom(tagClass)) {
                tagImpl.addAttribute("extend", "error");
            }
            try {
                tagObject = tagClass.newInstance();
            }
            catch (Throwable e) {
                tagImpl.addAttribute("loadable", "error");
            }
        }
        catch (ClassNotFoundException e) {
            tagImpl.addAttribute("found", "error");
            tagImpl.addAttribute("extend", "error");
            tagImpl.addAttribute("loadable", "error");
        }
        if (tag.getTeiClass() != null) {
            Element teiImpl = this.checkTeiClass(tag.getTeiClass());
            subsection.add(teiImpl);
        }
        TagAttribute[] attributes = tag.getAttributes();
        if (tagObject != null && attributes.length > 0) {
            DefaultElement attributesNode = new DefaultElement("attributes");
            subsection.add((Element)attributesNode);
            for (int j = 0; j < attributes.length; ++j) {
                Element attributeNode = this.checkAttribute(tagObject, attributes[j]);
                attributesNode.add(attributeNode);
            }
        }
        return subsection;
    }

    private Element checkTeiClass(String className) {
        DefaultElement teiImpl = new DefaultElement("teiclass");
        teiImpl.addAttribute("name", className);
        Class<?> teiClass = null;
        try {
            teiClass = Class.forName(className);
            if (!(class$javax$servlet$jsp$tagext$TagExtraInfo == null ? (class$javax$servlet$jsp$tagext$TagExtraInfo = TldChecker.class$("javax.servlet.jsp.tagext.TagExtraInfo")) : class$javax$servlet$jsp$tagext$TagExtraInfo).isAssignableFrom(teiClass)) {
                teiImpl.addAttribute("extend", "error");
            }
            try {
                teiClass.newInstance();
            }
            catch (Throwable e) {
                teiImpl.addAttribute("loadable", "error");
            }
        }
        catch (ClassNotFoundException e) {
            teiImpl.addAttribute("found", "error");
            teiImpl.addAttribute("extend", "error");
            teiImpl.addAttribute("loadable", "error");
        }
        return teiImpl;
    }

    private Element checkAttribute(Object tag, TagAttribute attribute) {
        DefaultElement errorNode;
        Class tldTypeClass;
        String tldType = attribute.getAttributeType();
        String tldName = attribute.getAttributeName();
        DefaultElement attributeNode = new DefaultElement("attribute");
        attributeNode.addAttribute("tldname", tldName);
        attributeNode.addAttribute("tldtype", StringUtils.defaultString((String)tldType));
        if (!PropertyUtils.isWriteable((Object)tag, (String)tldName)) {
            DefaultElement errorNode2 = new DefaultElement("error");
            errorNode2.addAttribute("level", "error");
            errorNode2.addText("Setter not found");
            attributeNode.add((Element)errorNode2);
        }
        Class tagType = null;
        try {
            tagType = PropertyUtils.getPropertyType((Object)tag, (String)tldName);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (tldType != null && tagType != null && !tagType.isAssignableFrom(tldTypeClass = this.getClassFromName(tldType))) {
            DefaultElement errorNode3 = new DefaultElement("error");
            errorNode3.addAttribute("level", "error");
            errorNode3.addText("Error in attribute type: tld declares [" + tldType + "], class declares [" + tagType.getName() + "]");
            attributeNode.add((Element)errorNode3);
        }
        attributeNode.addAttribute("tagtype", tagType == null ? "" : tagType.getName());
        if (tldType != null && !tldType.equals(tagType.getName())) {
            errorNode = new DefaultElement("error");
            errorNode.addAttribute("level", "warning");
            errorNode.addText("Inexact match: tld declares [" + tldType + "], class declares [" + tagType.getName() + "]");
            attributeNode.add((Element)errorNode);
        } else if (tldType == null && !(class$java$lang$String == null ? (class$java$lang$String = TldChecker.class$("java.lang.String")) : class$java$lang$String).equals(tagType)) {
            errorNode = new DefaultElement("error");
            errorNode.addAttribute("level", "info");
            errorNode.addText("Attribute type different from String and not declared in tld.");
            attributeNode.add((Element)errorNode);
        }
        return attributeNode;
    }

    private Class getClassFromName(String className) {
        Class<Constable> tldTypeClass = null;
        if ("int".equals(className)) {
            tldTypeClass = Integer.TYPE;
        } else if ("long".equals(className)) {
            tldTypeClass = Long.TYPE;
        } else if ("double".equals(className)) {
            tldTypeClass = Double.TYPE;
        } else if ("boolean".equals(className)) {
            tldTypeClass = Boolean.TYPE;
        } else if ("char".equals(className)) {
            tldTypeClass = Character.TYPE;
        } else if ("byte".equals(className)) {
            tldTypeClass = Byte.TYPE;
        }
        if (tldTypeClass == null) {
            try {
                tldTypeClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("unable to find class [" + className + "] declared in 'type' attribute"));
            }
        }
        return tldTypeClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

