/*
 * Decompiled with CFR 0.152.
 */
package net.sf.maventaglib.checker;

import java.util.ArrayList;
import net.sf.maventaglib.checker.Tag;
import net.sf.maventaglib.checker.TagAttribute;
import net.sf.maventaglib.checker.Tld;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TldParser {
    private static Log log = LogFactory.getLog((Class)(class$net$sf$maventaglib$checker$TldParser == null ? (class$net$sf$maventaglib$checker$TldParser = TldParser.class$("net.sf.maventaglib.checker.TldParser")) : class$net$sf$maventaglib$checker$TldParser));
    static /* synthetic */ Class class$net$sf$maventaglib$checker$TldParser;

    private TldParser() {
    }

    public static Tld parse(Document tldDoc, String tldName) {
        Tld tld = new Tld();
        tld.setFilename(tldName);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        NodeList tagList = tldDoc.getElementsByTagName("taglib").item(0).getChildNodes();
        for (int i = 0; i < tagList.getLength(); ++i) {
            Node tagNode = tagList.item(i);
            if ("shortname".equals(tagNode.getNodeName()) || "short-name".equals(tagNode.getNodeName())) {
                Node child = tagNode.getFirstChild();
                if (child != null) {
                    tld.setName(child.getNodeValue());
                }
            } else if ("tag".equals(tagNode.getNodeName())) {
                Tag tag = TldParser.parseTag(tagNode);
                tags.add(tag);
            }
            tld.setTags(tags.toArray(new Tag[tags.size()]));
        }
        return tld;
    }

    private static Tag parseTag(Node tagNode) {
        Tag tag = new Tag();
        ArrayList<TagAttribute> attributes = new ArrayList<TagAttribute>();
        NodeList tagAttributes = tagNode.getChildNodes();
        for (int k = 0; k < tagAttributes.getLength(); ++k) {
            Node tagAttribute = tagAttributes.item(k);
            String nodeName = tagAttribute.getNodeName();
            if ("name".equals(nodeName)) {
                tag.setName(tagAttribute.getFirstChild().getNodeValue());
            } else if ("tag-class".equals(nodeName) || "tagclass".equals(nodeName)) {
                tag.setTagClass(tagAttribute.getFirstChild().getNodeValue());
            } else if ("tei-class".equals(nodeName) || "teiclass".equals(nodeName)) {
                tag.setTeiClass(tagAttribute.getFirstChild().getNodeValue());
            } else if ("attribute".equals(nodeName)) {
                TagAttribute attribute = TldParser.parseTagAttribute(tagAttribute);
                attributes.add(attribute);
            }
            tag.setAttributes(attributes.toArray(new TagAttribute[attributes.size()]));
        }
        return tag;
    }

    private static TagAttribute parseTagAttribute(Node tagAttribute) {
        TagAttribute attribute = new TagAttribute();
        NodeList attributeParams = tagAttribute.getChildNodes();
        for (int z = 0; z < attributeParams.getLength(); ++z) {
            Node param = attributeParams.item(z);
            if (param.getNodeType() == 3 || !param.hasChildNodes()) continue;
            if ("name".equals(param.getNodeName())) {
                attribute.setAttributeName(param.getFirstChild().getNodeValue());
                continue;
            }
            if (!"type".equals(param.getNodeName())) continue;
            attribute.setAttributeType(param.getFirstChild().getNodeValue());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)attribute);
        }
        return attribute;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

